<?php

/**
 * Shortcode Field Class
 */
class WeForms_Form_Field_Shortcode extends WeForms_Field_Contract {

    function __construct() {
        $this->name       = __( 'Shortcode', 'weforms' );
        $this->input_type = 'shortcode';
        $this->icon       = 'calendar-o';
    }

    /**
     * Render the text field
     *
     * @param  array  $field_settings
     * @param  integer  $form_id
     *
     * @return void
     */
    public function render( $field_settings, $form_id ) {
        $value = '';
        ?>
        <li <?php $this->print_list_attributes( $field_settings ); ?>>
            <?php $this->print_label( $field_settings ); ?>

            <div class="wpuf-fields <?php echo ' wpuf_'.$field_settings['name'].'_'.$form_id; ?>">
                <?php echo do_shortcode( $field_settings['shortcode'] ); ?>
            </div>
        </li>
        <?php
    }

    /**
     * It's a full width block
     *
     * @return boolean
     */
    public function is_full_width() {
        return true;
    }

    /**
     * Get field options setting
     *
     * @return array
     */
    public function get_options_settings() {
        $settings = array(
            array(
                'name'      => 'label',
                'title'     => __( 'Field Label', 'weforms' ),
                'type'      => 'text',
                'section'   => 'basic',
                'priority'  => 10,
                'help_text' => __( 'Enter a title of this field', 'weforms' ),
            ),
            array(
                'name'          => 'shortcode',
                'title'         => __( 'Shortcode', 'wpuf-pro' ),
                'type'          => 'text',
                'section'       => 'basic',
                'priority'      => 10,
                'help_text'     => __( 'Input your shortcode here', 'wpuf-pro' ),
            ),
            array(
                'name'      => 'css',
                'title'     => __( 'CSS Class Name', 'weforms' ),
                'type'      => 'text',
                'section'   => 'advanced',
                'priority'  => 22,
                'help_text' => __( 'Provide a container class name for this field. Available classes: wpuf-col-half, wpuf-col-half-last, wpuf-col-one-third, wpuf-col-one-third-last', 'weforms' ),
            )
        );

        return $settings;
    }

    /**
     * Get the field props
     *
     * @return array
     */
    public function get_field_props() {
        return array(
            'template'          => $this->get_type(),
            'label'             => $this->get_name(),
            'shortcode'         => '[your_shortcode]',
            'id'                => 0,
            'css'               => '',
            'is_new'            => true,
            'wpuf_cond'         => null
        );
    }
}