<?php

/**
 * Signature Field Class
 */
class WeForms_Form_Field_Signature extends WeForms_Field_Contract {

    function __construct() {
        $this->name       = __( 'Signature Field', 'weforms' );
        $this->input_type = 'signature_field';
        $this->icon       = 'pencil-square-o';
    }

    /**
     * Render the text field
     *
     * @param  array  $field_settings
     * @param  integer  $form_id
     *
     * @return void
     */
    public function render( $field_settings, $form_id ) {
        $unique_id = sprintf( '%s-%d', $field_settings['name'], $form_id );
        ?>
        <li <?php $this->print_list_attributes( $field_settings ); ?>>
            <?php $this->print_label( $field_settings, $form_id ); ?>

            <div class="wpuf-fields">
                <div id="wpuf-<?php echo $unique_id; ?>-signature-container">
                    <div class="wpuf-signature-pad-field" data-required="<?php echo $field_settings['required']; ?>">
                        <div id="wpuf-<?php echo $unique_id; ?>-signature" data-form_id="<?php echo $form_id; ?>" class="<?php echo ' wpuf_' . $field_settings['name'] . '_' . $form_id; ?> signature-field" href="#">
                            <canvas id="wpuf-signature-pad" class="signature-pad" style="border: 1px solid; border-width: thin;"></canvas>
                        </div>
                        <input type="text" id='wpuf_signature_image' name="wpuf_signature_image" data-type="text" data-required="<?php echo $field_settings['required']; ?>" value="" style="opacity:0;position:absolute;top:0;left:0">
                        <div>
                            <a href="#" id="wpuf-signature-clear">Clear</a>
                        </div>
                    </div>

                </div><!-- .container -->

                <?php $this->help_text( $field_settings ); ?>

            </div> <!-- .wpuf-fields -->

        </li>
        <?php
    }

    /**
     * Get field options setting
     *
     * @return array
     */
    public function get_options_settings() {
        $default_options      = $this->get_default_option_settings(true, array('dynamic', 'width') ); // exclude dynamic

        $settings = array(
            array(
                'name'      => 'width',
                'title'     => __( 'Field Size', 'weforms' ),
                'type'      => 'radio',
                'options'   => array(
                    'small'     => __( 'Small', 'weforms' ),
                    'medium'    => __( 'Medium', 'weforms' ),
                    'large'     => __( 'Large', 'weforms' ),
                ),
                'section'   => 'advanced',
                'priority'  => 21,
                'default'   => 'large',
                'inline'    => true,
            ),
        );

        return array_merge( $default_options, $settings );
    }

    /**
     * Get the field props
     *
     * @return array
     */
    public function get_field_props() {
        $defaults = $this->default_attributes();

        return $defaults;
    }


    /**
     * Prepare entry
     *
     * @param $field
     *
     * @return @return mixed
     */
    public function prepare_entry( $field, $args = [] ) {
        $args = ! empty( $args ) ? $args : $_POST;

        return isset( $args['wpuf_signature_image'] ) ? $args['wpuf_signature_image'] : array();
    }

    /**
     * Frontend signature scripts
     *
     * @param  array $scripts
     *
     * @return array
     */
    public function frontend_signature_scripts() {
        wp_enqueue_script( 'weforms_signature_script', plugins_url( '/assets/js/signature_pad.min.js', __FILE__ ), array( 'jquery' ), false, false );
    }
}
