<?php

/**
 * Aweber API  manager class
 *
 * @since 1.4.2
 */

class Weforms_Aweber_Controller extends Weforms_REST_Controller {

    /**
     * Endpoint namespace
     *
     * @var string
     */
    protected $namespace = 'weforms/v1';

    /**
     * Route name
     *
     * @var string
     */
    protected $base = 'aweber';

    /**
     * Register all routes releated with forms
     *
     * @return void
     */
    public function register_routes() {

        register_rest_route( $this->namespace, '/'. $this->base, array(
                array(
                    'methods'             => WP_REST_Server::READABLE,
                    'callback'            => array( $this, 'aweber_fetch_lists' ),
                    'permission_callback' => array( $this, 'get_items_permissions_check' ),
                    'args'     => array(
                        'context' => $this->get_context_param( [ 'default' => 'view' ] )
                    ),
                ),
            )
        );

        register_rest_route( $this->namespace, '/'. $this->base, array(
                array(
                    'methods'             => WP_REST_Server::EDITABLE,
                    'callback'            => array( $this, 'aweber_update_lists' ),
                    'permission_callback' => array( $this, 'get_items_permissions_check' ),
                ),
            )
        );
    }

    /**
     * get Collection of Aweber List
     *
     * @since 1.4.2
     *
     * @param WP_REST_Request $request Full details about the request.
     *
     * @return WP_REST_Response|WP_Error Response object on success, or WP_Error object on failure.
     **/
    public function aweber_fetch_lists( $request ) {
        $lists    = get_option( 'weforms_aweber_mail_list', array( ) );
        $response = $this->prepare_response_for_collection( $lists);
        $response = rest_ensure_response( $response );

        return $response;
    }

    public function aweber_update_lists( $request ) {
        $lists     = array();

        try {
            $token    = get_option( 'weforms_aweber_access_token' );
            $aweber   = $this->aweber();
            $account  = $aweber->getAccount( $token['token'], $token['secret'] );
            $listURL  = "/accounts/{$account->id}/lists/";
            $response = $account->loadFromUrl($listURL);

            if ( isset($response->data) && isset( $response->data['entries'] ) ) {
                foreach ( $response->data['entries'] as $list) {
                    $lists[] = array(
                        'id'     => $list['id'],
                        'name'   => $list['name']
                    );
                }

                update_option( 'weforms_aweber_mail_list', $lists );
            }

            $lists    = get_option( 'weforms_aweber_mail_list', array( ) );
            $response = $this->prepare_response_for_collection( $lists );
            $response = rest_ensure_response( $response );

            return $response;
        }
        catch( Exception $e ) {
            return new WP_Error( 'rest_weforms_aweber_invalid_data', $e->getMessage(), array( 'status' => 404 ) );
        }
    }


     /**
     * Require the aweber class if not exists
     *
     * @return void
     */
    public function aweber() {
        if ( ! class_exists( 'AWeberAPI' ) ) {
            require_once dirname( __FILE__ ) . '/../aweber_api/aweber_api.php';
        }

        static $aweber = false;

        if ( $aweber ) {
            return $aweber;
        }

        $aweber = new AWeberAPI($this->get_api_key(), $this->get_api_secret());

        return $aweber;
    }

    /**
     * Get the APP ID
     *
     * @return string
     */
    private function get_app_id() {
        return 'b25b1506';;
    }

    /**
     * Get the API key
     *
     * @return string
     */
    private function get_api_key() {
        return 'Ak85sNPps2iI0YJLKJ2wgfcZ';
    }

    /**
     * Get the API secret
     *
     * @return string
     */
    private function get_api_secret() {
        return 'wvUT7YPEt4x5jze3cQ8RpPnFCMcYrZJNgT1qPjIw';
    }
}
