<?php
/**
 * Plugin Name: Aweber Integration
 * Description: Subscribe a contact to Aweber when a form is submited
 * Plugin URI: https://wedevs.com/weforms/
 * Thumbnail URL: aweber.png
 * Author: weDevs
 * Version: 1.0
 * Author URI: https://wedevs.com
 */
require_once dirname( __FILE__ ) . '/class-integration-aweber.php';
/**
 * Aweber CLass
 */
class WeForms_Aweber {

    function __construct() {
        add_filter( 'weforms_integrations', array( $this, 'register_integration' ) );
        add_filter( 'weforms_rest_api_class_map', array( $this, 'register_aweber_rest_api_integration' ) );
    }

    /**
     * Register default integrations
     *
     * @param  array $integrations
     *
     * @return array
     */
    public function register_integration( $integrations ) {
        $integrations = array_merge( $integrations, array( 'WeForms_Integration_Aweber' ) );

        return $integrations;
    }

    public function register_aweber_rest_api_integration( $class_map ) {
        $class_map[dirname( __FILE__ ) . '/api/class-weforms-aweber-controller.php'] = 'Weforms_Aweber_Controller';

        return $class_map;
    }
}

new WeForms_Aweber();
