<?php

/**
 * Aweber Integration
 */
class WeForms_Integration_Aweber extends WeForms_Pro_Integration {

    function __construct() {

        $this->id                = 'aweber';
        $this->title             = __( 'Aweber', 'weforms-pro' );
        $this->icon              = WEFORMS_ASSET_URI . '/images/icon-aweber.svg';
        $this->template          = dirname( __FILE__ ) . '/component/template.php';
        $this->settings_template = dirname( __FILE__ ) . '/views/settings.php';

        $this->settings_fields = array(
            'enabled' => false,
            'list'    => '',
            'fields'  => array(
                'email'      => '',
                'first_name' => '',
                'last_name'  => '',
                'tags'       => ''
            )
        );

        $this->load_settings();

        add_filter( 'admin_footer', array( $this, 'load_template' ) );

        add_action( 'wp_ajax_wpuf_aweber_fetch_lists', array( $this, 'fetch_lists' ) );
        add_action( 'wp_ajax_wpuf_aweber_update_lists', array( $this, 'update_lists' ) );

        add_filter( 'weforms_builder_scripts', array( $this, 'enqueue_mixin' ) );
        add_action( 'weforms_entry_submission', array( $this, 'subscribe_user' ), 10, 4 );

        add_action( 'admin_post_weforms_aweber_auth', array( $this, 'auth' ));
        add_action( 'admin_post_weforms_aweber_callback', array( $this, 'callback' ));
        add_filter( 'wp_ajax_weforms_aweber_disconnect', array( $this, 'disconnect' ) );

        add_filter( 'weforms_get_settings', array( $this, 'set_default_settings' ) );
        add_action( 'weforms_settings_tabs', array( $this, 'settings_tabs' ), 11 );
    }

    /**
     * Disconnect
     *
     * @param array $settings
     *
     * @return array
     */
    function disconnect() {

        delete_option( 'weforms_aweber_access_token' );

        wp_send_json_success();
    }

    /**
     * Set Default Settings
     *
     * @param array $settings
     *
     * @return array
     */
    function set_default_settings( $settings ) {

        $token                     = get_option( 'weforms_aweber_access_token' );
        $settings['aweber_status'] = !empty( $token['token'] ) ? true : false;

        return $settings;
    }

    /**
     * Render the settings panel
     *
     * @return void
     */
    public function settings_tabs( $tabs ) {
        $tabs['aweber'] = array(
            'label' => __( 'Aweber', 'weforms-pro' ),
            'icon'  => WEFORMS_ASSET_URI . '/images/integrations/aweber.svg',
        );

        return $tabs;
    }

    /**
     * auth
     *
     * @return
     **/
    function auth( ) {

        try {
           $aweber = $this->aweber();

            // Put the callback URL of your app below or set to 'oob' if your app isnt
            // a web based application.
            $callbackURL    = add_query_arg( 'action', 'weforms_aweber_callback', admin_url( 'admin-post.php' ));

            // get a request token
            list($key, $secret) = $aweber->getRequestToken($callbackURL);

            // get the authorization URL
            $authorizationURL = $aweber->getAuthorizeUrl();

            // store the request token secret
            setcookie('secret', $secret);

            // redirect user to authorization URL
            header("Location: $authorizationURL");
            exit();

        }
        catch( Exception $e ) {
            weforms()->log('error', 'Aweber error: ' . $e->getMessage() );
            wp_redirect( add_query_arg( 'page', 'weforms#/settings', admin_url( 'admin.php' )) );
            exit;
        }
    }

    /**
     * auth
     *
     * @return
     **/
    function callback( ) {

        try {
            $aweber = $this->aweber();

            // Pull the request token key and verifier code from the URL
            $aweber->user->requestToken = @$_GET['oauth_token'];
            $aweber->user->verifier = @$_GET['oauth_verifier'];

            // retrieve the stored request token secret
            $aweber->user->tokenSecret = @$_COOKIE['secret'];

            // Exchange a request token with a verifier code for an access token.
            list($accessTokenKey, $accessTokenSecret) = $aweber->getAccessToken();

            update_option( 'weforms_aweber_access_token', array( 'token' => $accessTokenKey, 'secret'=> $accessTokenSecret ) );

        }
        catch( Exception $e ) {
            weforms()->log('error', 'Aweber error: ' . $e->getMessage() );
        }

        wp_redirect( add_query_arg( 'page', 'weforms#/settings', admin_url( 'admin.php' )) );
    }

    /**
     * Enqueue the mixin
     *
     * @param $scritps
     *
     * @return array
     */
    public function enqueue_mixin( $scripts ) {

        $scripts['weforms-int-aweber'] = array(
            'src' => $this->module_component_file( __FILE__ ),
            'deps' => array( 'weforms-form-builder-components' )
        );

        return $scripts;
    }

    /**
     * Get the APP ID
     *
     * @return string
     */
    private function get_app_id() {
        return 'b25b1506';;
    }

    /**
     * Get the API key
     *
     * @return string
     */
    private function get_api_key() {
        return 'Ak85sNPps2iI0YJLKJ2wgfcZ';
    }

    /**
     * Get the API secret
     *
     * @return string
     */
    private function get_api_secret() {
        return 'wvUT7YPEt4x5jze3cQ8RpPnFCMcYrZJNgT1qPjIw';
    }


    /**
     * Fetch awebers saved list from server
     *
     * @return array
     */
    public function fetch_lists() {
        $lists = get_option( 'weforms_aweber_mail_list', array() );

        wp_send_json_success( $lists );
    }

    /**
     * Require the aweber class if not exists
     *
     * @return void
     */
    public function require_aweber() {
        require_once dirname( __FILE__ ) . '/aweber_api/aweber_api.php';
    }

    /**
     * Require the aweber class if not exists
     *
     * @return void
     */
    public function aweber() {

        if ( ! class_exists( 'AWeberAPI' ) ) {
            require_once dirname( __FILE__ ) . '/aweber_api/aweber_api.php';
        }

        static $aweber = false;

        if ( $aweber ) {
            return $aweber;
        }

        $aweber = new AWeberAPI($this->get_api_key(), $this->get_api_secret());

        return $aweber;
    }

    /**
     * Fetch the udpated list from aweber, save and return it
     *
     * @return array
     */
    public function update_lists() {

        $lists     = array();

        try {

            $token    = get_option( 'weforms_aweber_access_token' );
            $aweber   = $this->aweber();
            $account  = $aweber->getAccount( $token['token'], $token['secret'] );
            $listURL  = "/accounts/{$account->id}/lists/";
            $response = $account->loadFromUrl($listURL);

            if ( isset($response->data) && isset( $response->data['entries'] ) ) {
                foreach ( $response->data['entries'] as $list) {
                    $lists[] = array(
                        'id'     => $list['id'],
                        'name'   => $list['name']
                    );
                }

                update_option( 'weforms_aweber_mail_list', $lists );
            }

            wp_send_json_success( $lists );
        }
        catch( Exception $e ) {
            wp_send_json_error( $e->getMessage() );
        }
    }

    /**
     * Subscribe a user when a form is submitted
     *
     * @param  int $entry_id
     * @param  int $form_id
     * @param  int $page_id
     * @param  array $form_settings
     *
     * @return void
     */
    public function subscribe_user( $entry_id, $form_id, $page_id, $form_settings ) {

        $integration = weforms_is_integration_active( $form_id, $this->id );

        if ( false === $integration ) {
            return;
        }

        if ( empty( $integration->list ) || empty( $integration->fields->email ) ) {
            return;
        }

        $email = WeForms_Notification::replace_field_tags( $integration->fields->email, $entry_id );

        if ( empty( $email ) ) {
            return;
        }

        $first_name = WeForms_Notification::replace_name_tag( $integration->fields->first_name, $entry_id );
        $last_name  = WeForms_Notification::replace_name_tag( $integration->fields->last_name, $entry_id );

        try {

            $token    = get_option( 'weforms_aweber_access_token' );
            $aweber   = $this->aweber();
            $account  = $aweber->getAccount( $token['token'], $token['secret'] );

            $listURL  = "/accounts/{$account->id}/lists/{$integration->list}";
            $response = $account->loadFromUrl($listURL);
            $tags     = $integration->fields->tags ? explode(",", $integration->fields->tags) : array();

            $params = array(
                'ip_address' => @$_SERVER['REMOTE_ADDR'],
                'email'      => $email,
                'name'       => $first_name . ' ' . $last_name,
                'tags'       => $tags,
            );

            $subscribers = $response->subscribers;
            $new_subscriber = $subscribers->create($params);

        }
        catch( Exception $e ) {
            weforms()->log('error', 'Aweber error: ' . $e->getMessage() );
        }

    }
}

