<div>
    <div class="wpuf-int-form-row">
        <div class="wpuf-int-field-label">
            <label for="aweber-list-id"><?php _e( 'List', 'weforms-pro' ); ?></label>

            <a href="#" v-on:click.prevent="updateLists($event.target)" class="wpuf-integration-updater" title="<?php esc_attr_e( 'Update the lists', 'weforms-pro' ); ?>"><span class="dashicons dashicons-update"></span></a>
        </div>
        <div class="wpuf-int-field">
            <select v-model="settings.list" id="aweber-list-id">
                <option value=""><?php _e( '&mdash; Select List &mdash;', 'weforms-pro' ); ?></option>
                <option v-for="list in lists" :value="list.id">{{ list.name }}</option>
            </select>

            <span class="description"><?php _e( 'Select your Aweber list for subscription', 'weforms-pro' ); ?></span>
        </div>
    </div>

    <fieldset>
        <legend><?php _e( 'Mapping Fields', 'textdomain' ); ?></legend>

        <p class="description" style="padding: 0 0 10px 0;">
            <?php _e( 'Please map the form input fields with Aweber required fields', 'textdomain' ); ?>
        </p>

        <div class="wpuf-int-form-row mapping-fields">
            <div class="wpuf-int-field-label">
                <label for="aweber-list-id"><?php _e( 'Email Address', 'weforms-pro' ); ?> <span class="required">*</span></label>
            </div>
            <div class="wpuf-int-field">
                <div class="wpuf-int-field-small">
                    <input type="email" class="regular-text" v-model="settings.fields.email">
                    <wpuf-merge-tags filter="email_address" v-on:insert="insertValue" field="email"></wpuf-merge-tags>
                </div>
            </div>
        </div>

        <div class="wpuf-int-form-row">
            <div class="wpuf-int-field-label">
                <label for="aweber-list-id"><?php _e( 'First Name', 'weforms-pro' ); ?></label>
            </div>
            <div class="wpuf-int-field">
                <div class="wpuf-int-field-small">
                    <input type="text" class="regular-text" v-model="settings.fields.first_name">
                    <wpuf-merge-tags v-on:insert="insertValue" field="first_name"></wpuf-merge-tags>
                </div>
            </div>
        </div>

        <div class="wpuf-int-form-row">
            <div class="wpuf-int-field-label">
                <label for="aweber-list-id"><?php _e( 'Last Name', 'weforms-pro' ); ?></label>
            </div>
            <div class="wpuf-int-field">
                <div class="wpuf-int-field-small">
                    <input type="text" class="regular-text" v-model="settings.fields.last_name">
                    <wpuf-merge-tags v-on:insert="insertValue" field="last_name"></wpuf-merge-tags>
                </div>
            </div>
        </div>

        <div class="wpuf-int-form-row">
            <div class="wpuf-int-field-label">
                <label for="aweber-list-id"><?php _e( 'Tags', 'weforms-pro' ); ?></label>
            </div>
            <div class="wpuf-int-field">
                <div class="wpuf-int-field-small">
                    <input type="text" class="regular-text" v-model="settings.fields.tags" placeholder="Enter Tags">
                </div>
                <div class="description" style="color: gray; margin-top: 5px; margin-left: 1px;">
                    <small><?php _e( 'Enter multiple tags separated with coma', 'weforms-pro' ); ?></small>
                </div>
            </div>
        </div>
    </fieldset>
</div>
