<?php
/**
 * Plugin Name: Calculation
 * Description: Add calculation capability to numeric fields
 * Plugin URI: https://wedevs.com/weforms/
 * Thumbnail URL: calculation.png
 * Author: weDevs
 * Version: 1.0
 * Author URI: https://wedevs.com
 *
 */

class WeForms_Calculation extends WeForms_Abstract_Integration {

    /**
     * Init
     */
    function __construct() {

        $this->id                = 'calculation';
        $this->title             = 'Calculation';
        $this->icon              = WEFORMS_PRO_ASSETS . '/images/calculation.png';

        $this->load_settings();

        add_action( 'admin_enqueue_scripts', array( $this, 'register_scripts' ), 99 );
        add_action( 'weforms_form_fields_top', array( $this, 'prepare_form_calculation' ), 10, 2 );

        add_filter( 'weforms_numeric_field_option_settings', array ( $this, 'add_field_options' ) );
        add_filter( 'weforms_numeric_field_props', array( $this, 'add_field_props' ) );
        add_filter( 'weforms_frontend_scripts', array( $this, 'frontend_scripts' ) );
        add_filter( 'wpuf-form-builder-i18n', array( $this, 'add_calculation_section' ) );
    }

    /**
     * Register Admin Scripts
     */
    public function register_scripts() {
        $screen = get_current_screen();
        if ( $screen->base != 'toplevel_page_weforms' ) {
            return;
        }

        //wp_enqueue_script( 'weforms-calculation-js', plugins_url( '/assets/js/', __FILE__ ), array('jquery'), false, false );
        //wp_enqueue_script( 'weforms-calculation-lib', plugins_url( '/assets/js/mathjs-expression-parser.min.js', __FILE__ ), array('jquery'), false, false );
        wp_enqueue_style( 'weforms-calculation-css', plugins_url( '/assets/css/calculation-styles.css', __FILE__ ) );
    }

    /**
     * Register Frontend Scripts
     *
     * @param $scripts
     * @return array
     */
    public function frontend_scripts( $scripts ) {
        $scripts['weforms-calculation-frontend'] = array(
            'src'       => plugins_url( '/assets/js/calculation-script.js', __FILE__ ),
            'deps'      => array( 'jquery', 'wpuf-form' ),
            'in_footer' => true
        );

        $scripts['weforms-calculation-lib'] = array(
            'src'       => plugins_url( '/assets/js/mathjs-expression-parser.min.js', __FILE__ ),
            'deps'      => array( 'jquery' ),
            'in_footer' => true
        );

        return $scripts;
    }

    /**
     *
     * @param $i18scripts
     * @return mixed
     */
    public function add_calculation_section( $i18scripts ) {
        $i18scripts['calculation']     = __( 'Calculation', 'weforms-pro' );
        $i18scripts['valid_formula']   = __( 'This is a Valid Formula!', 'weforms-pro' );
        $i18scripts['invalid_formula'] = __( 'This is an Invalid Formula!', 'weforms-pro' );

        return $i18scripts;
    }

    /**
     *  Add Field Options
     *
     * @param $calculation_options
     * @return array
     */
    public function add_field_options( $calculation_options ) {
        $calculation_options[] = array(
                'name'          => 'enable_calculation',
                'title'         => __( 'Enable Calculation', 'weforms-pro' ),
                'type'          => 'checkbox',
                'is_single_opt' => true,
                'options'       => array(
                    'yes'   => __( 'Enable Calculation', 'weforms-pro' )
                ),
                'default'       => '',
                'section'       => 'advanced',
                'priority'      => 24,
                'help_text'     => __( 'Select this option to enable calculation in this field.', 'weforms-pro' ),
        );

        $calculation_options[] =  array(
            'name'          => 'calculation_options',
            'title'         => __( 'Calculation Options', 'weforms-pro' ),
            'type'          => 'calculation_options',
            'section'       => 'advanced',
            'priority'      => 24,
        );

        return $calculation_options;
    }

    /**
     * Add calculation Field Props
     *
     * @param $props
     * @return mixed
     */
    public function add_field_props( $props ) {
        $props['calculation'] = array();
        $props['enable_calculation'] = '';
        $props['formula_field'] = '';

        return $props;
    }

    /**
     * Prepare Form Calculations
     *
     * @param $form
     * @param $form_fields
     */
    public function prepare_form_calculation( $form, $form_fields ) {
        $calculation_vars = array(); $field_names = array();

        foreach ( $form_fields as $field ) {
            if( isset( $field['name'] ) ) {
                $field_names[] = $field['name'];
                $temp = $field['name'];
            }

            if ( isset( $field['enable_calculation'] ) && ! $field['formula_field'] ) {
                continue;
            }

            if ( isset( $field['formula_field'] ) && !empty( $field['formula_field'] ) ) {
                $calculation_vars['formulas']["$temp"] = str_replace( '%', '*.01', $field['formula_field']);
            }
        }

        $calculation_vars = apply_filters( 'weforms_calculation_variables', $calculation_vars );

        wp_localize_script( 'weforms-calculation-frontend', 'weFormsCalculationObj', array(
            'form_fields'        => $field_names,
            'calculation_vars'   => $calculation_vars,
        ) );
    }
}

new WeForms_Calculation();
