<?php
/**
 * Plugin Name: Campaign Monitor
 * Description: Add your customers to Campaign Monitor list when they submit a form
 * Plugin URI: https://wedevs.com/weforms/
 * Thumbnail URL: campaign-monitor.png
 * Author: weDevs
 * Version: 1.0
 * Author URI: https://wedevs.com
 */

require_once dirname( __FILE__ ) . '/class-integration-campaign-monitor.php';

/**
 * MailChimp CLass
 */
class WeForms_Campaign_Monitor {

    function __construct() {
        add_filter( 'weforms_integrations', array( $this, 'register_integration' ) );
        add_filter( 'weforms_rest_api_class_map', array( $this, 'register_campaign_monitor_rest_api_integration' ), 10, 1 );
    }

    /**
     * Register default integrations
     *
     * @param  array $integrations
     *
     * @return array
     */
    public function register_integration( $integrations ) {
        $integrations = array_merge( $integrations, array( 'WeForms_Integration_Campaign_Monitor' ) );

        return $integrations;
    }

    public function register_campaign_monitor_rest_api_integration( $class_map ) {
        $class_map[dirname( __FILE__ ) . '/api/class-weforms-campaign-monitor-controller.php'] = 'WeForms_Campaign_Monitor_Controller';

        return $class_map;
    }
}

new WeForms_Campaign_Monitor();
