'use strict';

;(function ($) {

    Vue.component('wpuf-integration-campaign-monitor', {
        template: '#tmpl-wpuf-integration-campaign-monitor',
        mixins: [wpuf_mixins.integration_mixin],

        data: function data() {
            return {
                lists: []
            };
        },

        computed: {},

        created: function created() {
            this.fetchLists();
        },

        methods: {

            fetchLists: function fetchLists(target) {
                var self = this;

                wp.ajax.send('wpuf_campaign_monitor_fetch_lists', {
                    data: {
                        _wpnonce: weForms.nonce
                    },

                    success: function success(response) {
                        self.lists = response;
                    },

                    error: function error(_error) {
                        alert(_error);
                    }
                });
            },

            updateLists: function updateLists(target) {
                var self = this;

                var link = $(target).closest('a');

                link.addClass('updating');

                wp.ajax.send('wpuf_campaign_monitor_update_lists', {
                    data: {
                        _wpnonce: weForms.nonce
                    },

                    success: function success(response) {
                        self.lists = response;
                    },

                    error: function error(_error2) {
                        alert(_error2);
                    },

                    complete: function complete() {
                        link.removeClass('updating');
                    }
                });
            },

            insertValue: function insertValue(type, field, property) {
                var value = field !== undefined ? '{' + type + ':' + field + '}' : '{' + type + '}';

                this.settings.fields[property] = value;
            }
        }
    });
})(jQuery);
