<div>
    <div class="wpuf-int-form-row">
        <div class="wpuf-int-field-label">
            <label for="campaign-monitor-list-id"><?php _e( 'List', 'default' ); ?></label>

            <a href="#" v-on:click.prevent="updateLists($event.target)" class="wpuf-integration-updater" title="<?php esc_attr_e( 'Update the lists', 'default' ); ?>"><span class="dashicons dashicons-update"></span></a>
        </div>
        <div class="wpuf-int-field">
            <select v-model="settings.list" id="campaign-monitor-list-id">
                <option value=""><?php _e( '&mdash; Select List &mdash;', 'default' ); ?></option>
                <option v-for="list in lists" :value="list.id">{{ list.name }}</option>
            </select>

            <span class="description"><?php _e( 'Select your campaign monitor list for subscription', 'default' ); ?></span>
        </div>
    </div>

    <fieldset>
        <legend><?php _e( 'Mapping Fields', 'textdomain' ); ?></legend>

        <p class="description" style="padding: 0 0 10px 0;">
            <?php _e( 'Please map the form input fields with campaign monitor required fields', 'textdomain' ); ?>
        </p>

        <div class="wpuf-int-form-row mapping-fields">
            <div class="wpuf-int-field-label">
                <label for="campaign-monitor-list-id"><?php _e( 'Email Address', 'default' ); ?> <span class="required">*</span></label>
            </div>
            <div class="wpuf-int-field">
                <div class="wpuf-int-field-small">
                    <input type="email" class="regular-text" v-model="settings.fields.email">
                    <wpuf-merge-tags filter="email_address" v-on:insert="insertValue" field="email"></wpuf-merge-tags>
                </div>
            </div>
        </div>

        <div class="wpuf-int-form-row">
            <div class="wpuf-int-field-label">
                <label for="campaign-monitor-list-id"><?php _e( 'First Name', 'default' ); ?></label>
            </div>
            <div class="wpuf-int-field">
                <div class="wpuf-int-field-small">
                    <input type="text" class="regular-text" v-model="settings.fields.first_name">
                    <wpuf-merge-tags v-on:insert="insertValue" field="first_name"></wpuf-merge-tags>
                </div>
            </div>
        </div>

        <div class="wpuf-int-form-row">
            <div class="wpuf-int-field-label">
                <label for="campaign-monitor-list-id"><?php _e( 'Last Name', 'default' ); ?></label>
            </div>
            <div class="wpuf-int-field">
                <div class="wpuf-int-field-small">
                    <input type="text" class="regular-text" v-model="settings.fields.last_name">
                    <wpuf-merge-tags v-on:insert="insertValue" field="last_name"></wpuf-merge-tags>
                </div>
            </div>
        </div>
    </fieldset>
</div>