<?php

/**
 * GetResponse API  manager class
 *
 * @since 1.4.2
 */

class WeForms_Getresponse_Controller extends Weforms_REST_Controller {

    /**
     * Endpoint namespace
     *
     * @var string
     */
    protected $namespace = 'weforms/v1';

    /**
     * Route name
     *
     * @var string
     */
    protected $base = 'getresponse';

    /**
     * Register all routes releated with forms
     *
     * @return void
     */
    public function register_routes() {

        register_rest_route( $this->namespace, '/'. $this->base, array(
                array(
                    'methods'             => WP_REST_Server::READABLE,
                    'callback'            => array( $this, 'getresponse_fetch_lists' ),
                    'permission_callback' => array( $this, 'get_items_permissions_check' ),
                    'args'     => array(
                        'context' => $this->get_context_param( [ 'default' => 'view' ] )
                    ),
                ),
            )
        );

        register_rest_route( $this->namespace, '/'. $this->base, array(
                array(
                    'methods'             => WP_REST_Server::EDITABLE,
                    'callback'            => array( $this, 'getresponse_update_lists' ),
                    'permission_callback' => array( $this, 'get_items_permissions_check' ),
                ),
            )
        );
    }

    /**
     * get Collection of GetResponse Lists
     *
     * @since 1.4.2
     *
     * @param WP_REST_Request $request Full details about the request.
     *
     * @return WP_REST_Response|WP_Error Response object on success, or WP_Error object on failure.
     **/
    public function getresponse_fetch_lists( $request ) {
        $lists    = get_option( 'wpuf_gr_lists', array( ) );
        $response = $this->prepare_response_for_collection( $lists);
        $response = rest_ensure_response( $response );

        return $response;
    }

    public function getresponse_update_lists( $request ) {
        $this->require_getresponse();
        $lists       = array();
        $getresponse = new GetResponse( $this->get_api_key() );
        $response    = $getresponse->getCampaigns();

        if ( $response ) {
            foreach ($response as $list) {
                $lists[] = array(
                    'id'     => $list->campaignId,
                    'name'   => $list->name
                );
            }

            update_option( 'wpuf_gr_lists', $lists );
        }

        $response = $this->prepare_response_for_collection( $lists);
        $response = rest_ensure_response( $response );

        return $response;
    }

    /**
     * Require the getresponse class if not exists
     *
     * @return void
     */
    public function require_getresponse() {
        if ( ! class_exists( 'GetResponse' ) ) {
            require_once dirname( __FILE__ ) . '/../class-getresponse.php';
        }
    }

    /**
     * Get the API key
     *
     * @return string
     */
    private function get_api_key() {
        $api_key = weforms_get_settings( 'getresponse_api_key' );

        return $api_key;
    }
}
