<?php

/**
 * GetResponse Integration
 */
class WeForms_Integration_GetResponse extends WeForms_Pro_Integration {

    function __construct() {

        $this->id              = 'getresponse';
        $this->title           = __( 'GetResponse', 'weforms-pro' );
        $this->icon            = WEFORMS_ASSET_URI . '/images/icon-get-response.png';
        $this->template        = dirname( __FILE__ ) . '/component/template.php';
        $this->settings_template = dirname( __FILE__ ) . '/views/settings.php';

        $this->settings_fields = array(
            'enabled' => false,
            'list'    => '',
            'double'  => false,
            'fields'  => array(
                'email'      => '',
                'first_name' => '',
                'last_name'  => ''
            )
        );

        $this->load_settings();

        add_filter( 'admin_footer', array( $this, 'load_template' ) );

        add_action( 'wp_ajax_wpuf_getresponse_fetch_lists', array( $this, 'fetch_lists' ) );
        add_action( 'wp_ajax_wpuf_getresponse_update_lists', array( $this, 'update_lists' ) );

        add_filter( 'weforms_builder_scripts', array( $this, 'enqueue_mixin' ) );

        add_action( 'weforms_entry_submission', array( $this, 'subscribe_user' ), 10, 4 );
        add_action( 'weforms_settings_tabs', array( $this, 'settings_tabs' ), 11 );
    }

    /**
     * Enqueue the mixin
     *
     * @param $scritps
     *
     * @return array
     */
    public function enqueue_mixin( $scripts ) {

        $scripts['weforms-int-getresponse'] = array(
            'src' => $this->module_component_file( __FILE__ ),
            'deps' => array( 'weforms-form-builder-components' )
        );

        return $scripts;
    }

    /**
     * Get the API key
     *
     * @return string
     */
    private function get_api_key() {
        $api_key = weforms_get_settings( 'getresponse_api_key' );

        return $api_key;
    }

    /**
     * Fetch getresponses saved list from server
     *
     * @return array
     */
    public function fetch_lists() {
        $lists = get_option( 'wpuf_gr_lists', array() );

        wp_send_json_success( $lists );
    }

    /**
     * Require the getresponse class if not exists
     *
     * @return void
     */
    public function require_getresponse() {
        if ( ! class_exists( 'GetResponse' ) ) {
            require_once dirname( __FILE__ ) . '/class-getresponse.php';
        }
    }

    /**
     * Render the settings panel
     *
     * @return void
     */
    public function settings_tabs( $tabs ) {
        $tabs['getresponse'] = array(
            'label' => __( 'GetResponse', 'weforms-pro' ),
            'icon'  => WEFORMS_ASSET_URI . '/images/integrations/get-response2.svg',
        );

        return $tabs;
    }

    /**
     * Fetch the udpated list from getresponse, save and return it
     *
     * @return array
     */
    public function update_lists() {

        $this->require_getresponse();

        $lists     = array();
        $getresponse = new GetResponse( $this->get_api_key() );
        $response  = $getresponse->getCampaigns();

        if ( $response ) {
            foreach ($response as $list) {
                $lists[] = array(
                    'id'     => $list->campaignId,
                    'name'   => $list->name
                );
            }

            update_option( 'wpuf_gr_lists', $lists );
        }

        wp_send_json_success( $lists );
    }

    /**
     * Subscribe a user when a form is submitted
     *
     * @param  int $entry_id
     * @param  int $form_id
     * @param  int $page_id
     * @param  array $form_settings
     *
     * @return void
     */
    public function subscribe_user( $entry_id, $form_id, $page_id, $form_settings ) {

        $integration = weforms_is_integration_active( $form_id, $this->id );

        if ( false === $integration ) {
            return;
        }

        if ( empty( $integration->list ) || empty( $integration->fields->email ) ) {
            return;
        }

        $email = WeForms_Notification::replace_field_tags( $integration->fields->email, $entry_id );

        if ( empty( $email ) ) {
            return;
        }

        $first_name = WeForms_Notification::replace_name_tag( $integration->fields->first_name, $entry_id );
        $last_name  = WeForms_Notification::replace_name_tag( $integration->fields->last_name, $entry_id );

        $this->require_getresponse();

        $param = (object) array(
            'name'  => $first_name . ' ' . $last_name,
            'email' => $email,
            'campaign'  => array( 'campaignId' => $integration->list ),
        );

        $getresponse = new GetResponse( $this->get_api_key() );

        $getresponse->addContact( $param );

    }
}

