<?php
/**
 * Plugin Name: GetResponse Integration
 * Description: Subscribe a contact to GetResponse when a form is submited
 * Plugin URI: https://wedevs.com/weforms/
 * Thumbnail URL: getresponse.png
 * Author: weDevs
 * Version: 1.0
 * Author URI: https://wedevs.com
 */
require_once dirname( __FILE__ ) . '/class-integration-getresponse.php';
/**
 * GetResponse CLass
 */
class WeForms_GetResponse {

    function __construct() {
        add_filter( 'weforms_integrations', array( $this, 'register_integration' ) );
        add_filter( 'weforms_rest_api_class_map', array( $this, 'register_getresponse_rest_api_integration' ), 10, 1 );
    }

    /**
     * Register default integrations
     *
     * @param  array $integrations
     *
     * @return array
     */
    public function register_integration( $integrations ) {
        $integrations = array_merge( $integrations, array( 'WeForms_Integration_GetResponse' ) );

        return $integrations;
    }

    public function register_getresponse_rest_api_integration( $class_map ) {
        $class_map[dirname( __FILE__ )  .'/api/class-weforms-getresponse-controller.php'] = 'WeForms_Getresponse_Controller';

        return $class_map;
    }
}

new WeForms_GetResponse();
