<?php
/**
 * Plugin Name: Google Analytics Integration
 * Description: Show your customers to Google Analytics when they submit a form
 * Plugin URI: https://wedevs.com/weforms/
 * Thumbnail URL: google-analytics.svg
 * Author: weDevs
 * Version: 1.0
 * Author URI: https://wedevs.com
 *
 */

require_once dirname( __FILE__ ) . '/class-integration-google-analytics.php';

/**
 * Google Analytics CLass
 */
class WeForms_Google_Analytics {

    function __construct() {
        add_filter( 'weforms_integrations', array( $this, 'register_integration' ) );
    }

    /**
     * Register default integrations
     *
     * @param  array $integrations
     *
     * @return array
     */
    public function register_integration( $integrations ) {

        $integrations = array_merge( $integrations, array( 'WeForms_Integration_Google_Analytics' ) );

        return $integrations;
    }
}

new WeForms_Google_Analytics();
