<div>
    <div v-if="is_authenticated">
        <div class="wpuf-int-form-row">
            <div class="wpuf-int-field-label">
                <label for="google-sheets-id"><?php _e( 'SpreadSheet', 'weforms-pro' ); ?></label>

                <a href="#" v-on:click.prevent="updateSheetsList($event.target)" class="wpuf-integration-updater" title="<?php esc_attr_e( 'Update the Sheets', 'weforms-pro' ); ?>"><span class="dashicons dashicons-update"></span></a>
            </div>
            <div class="wpuf-int-field">
                <select v-model="settings.spread_sheet" id="google-sheets-id" @change="updateSheets();">
                    <option value=""><?php _e( '&mdash; Select Sheet &mdash;', 'weforms-pro' ); ?></option>
                    <option v-for="sheet in sheets_list" :value="sheet.id">{{ sheet.name }}</option>
                </select>

                <span class="description"><?php _e( 'Select your google sheet for the submission entry', 'weforms-pro' ); ?></span>
            </div>
        </div>

        <div class="wpuf-int-form-row">
            <div class="wpuf-int-field-label">
                <label for="google-sheets-id"><?php _e( 'Sheet', 'weforms-pro' ); ?></label>

                <a href="#" v-on:click.prevent="updateSheetsList($event.target)" class="wpuf-integration-updater" title="<?php esc_attr_e( 'Update the Sheets', 'weforms-pro' ); ?>"><span class="dashicons dashicons-update"></span></a>
            </div>
            <div class="wpuf-int-field">
                <select v-model="settings.sheet" id="google-sheets-id">
                    <option value=""><?php _e( '&mdash; Select Sheet &mdash;', 'weforms-pro' ); ?></option>
                    <option v-for="sheet in sheets[settings.spread_sheet]" :value="sheet.id">{{ sheet.name }}</option>
                </select>

                <span class="description"><?php _e( 'Select sheet. We recommend using a blank sheet when you are setting this up.', 'weforms-pro' ); ?></span>
            </div>
        </div>


        <div class="wpuf-int-form-row">
            <div class="wpuf-int-field-label">
                <label for="google-sheets-id"><?php _e( 'Metadata', 'weforms-pro' ); ?></label>
            </div>
            <div class="wpuf-int-field">
                <div>
                    <ul style="margin: 5px 0px;">
                        <li style="display: inline-block; padding-left: 5px; padding-right: 5px;">
                            <label>
                                <input type="checkbox" value="created" v-model="meta_data">
                                    Creation Time
                                </input>
                            </label>
                        </li>
                        <li style="display: inline-block; padding-left: 5px; padding-right: 5px;">
                            <label>
                                <input type="checkbox" value="user" v-model="meta_data">
                                    User
                                </input>
                            </label>
                        </li>
                        <li style="display: inline-block; padding-left: 5px; padding-right: 5px;">
                            <label>
                                <input type="checkbox" value="ip_address" v-model="meta_data">
                                    IP Address
                                </input>
                            </label>
                        </li>
                        <li style="display: inline-block; padding-left: 5px; padding-right: 5px;">
                            <label>
                                <input type="checkbox" value="device" v-model="meta_data">
                                    Device
                                </input>
                            </label>
                        </li>
                        <li style="display: inline-block; padding-left: 5px; padding-right: 5px;">
                            <label>
                                <input type="checkbox" value="referer" v-model="meta_data">
                                    Referer
                                </input>
                            </label>
                        </li>
                    </ul>
                </div>

                <span class="description"><?php _e( 'Check those metadata you would like to be saved on the google sheet.', 'weforms-pro' ); ?></span>
            </div>
        </div>


        <div class="wpuf-int-form-row">
            <div class="wpuf-int-field-label">
                <label for="google-sheets-id"><?php _e( 'Header Row', 'weforms-pro' ); ?></label>
            </div>
            <div class="wpuf-int-field">

                <div class="submit-wrapper">
                    <button v-on:click.prevent="mapHeader($event.target)" class="button button-primary"><?php _e( 'Setup sheet header', 'weforms-pro' ); ?></button>
                </div>
                <br>

                <span class="description"><?php _e( 'Clicking this button will create the header row of your selected sheet. Use it when you are setting up a blank sheet. ', 'weforms-pro' ); ?></span>
            </div>
        </div>
    </div>
    <div v-else>
        <?php
            printf(
                __( 'Google Sheets account is not authenticated. Authenticate Google Sheets from the %ssettings%s page. You may take a look at the %sdocumentation%s.', 'weforms-pro' ),
                '<a href="' . admin_url( 'admin.php?page=weforms#/settings' ) . '">', '</a>',
                '<a href="https://wedevs.com/docs/weforms/integrations/google-sheets/" target="_blank" >', '</a>'
            );
        ?>
    </div>


</div>