<?php
/**
 * Plugin Name: Google Sheets Integration
 * Description: Add your customers to Google sheets when they submit a form
 * Plugin URI: https://wedevs.com/weforms/
 * Thumbnail URL: google-sheets.jpg
 * Author: weDevs
 * Version: 1.0
 * Author URI: https://wedevs.com
 */
require_once dirname( __FILE__ ) . '/class-integration-google-sheets.php';
/**
 * Google sheets CLass
 */
class WeForms_Google_Sheets {


    /**
     * Minimum PHP version required
     *
     * @var string
     */
    private $min_php = '5.6.0';


    function __construct() {
        if ( ! $this->is_supported_php( $this->min_php ) ) {
            add_action( 'admin_notices', array( $this , 'php_version_notice' ) );

            return;
        }

        add_filter( 'weforms_integrations', array( $this, 'register_integration' ) );
        add_filter( 'weforms_rest_api_class_map', array( $this, 'register_google_sheets_rest_api_integration' ), 10, 1 );
    }

    /**
     * Register default integrations
     *
     * @param  array $integrations
     *
     * @return array
     */
    public function register_integration( $integrations ) {
        $integrations = array_merge( $integrations, array( 'WeForms_Integration_Google_Sheets' ) );

        return $integrations;
    }

    public function register_google_sheets_rest_api_integration( $class_map ) {
        $class_map[dirname( __FILE__ ) . '/api/class-weforms-google-sheets-controller.php'] = 'Weforms_Google_Sheets_Controller';

        return $class_map;
    }

    /**
     * Show notice about PHP version
     *
     * @return void
     */
    function php_version_notice() {
        ?>
        <div class="error">  <p><?php _e( sprintf('weForms <strong>Google Sheets Integration</strong> requires PHP version <strong>%s</strong> or greater.', $this->min_php ), 'weforms' ); ?></p>
        </div>
        <?php
    }


    /**
     * Check if the PHP version is supported
     *
     * @return bool
     */
    public function is_supported_php( $min_php = null ) {
        $min_php = $min_php ? $min_php : $this->min_php;

        if ( version_compare( PHP_VERSION, $min_php , '<=' ) ) {
            return false;
        }

        return true;
    }

}

new WeForms_Google_Sheets();
