<?php

/**
 *  HubSpot Class
 *
 *  Handle API request and connect with HubSpot
 */
class weForms_HubSpot_API {

    /**
     * Get all forms with API key
     *
     * @param string $api_key
     *
     * @return array
     */
    public function get_forms( $api_key ) {

        $url = 'https://api.hubapi.com/forms/v2/forms?hapikey=' . $api_key;

        $response = wp_remote_get( $url );

        if ( is_wp_error( $response ) ) {
           return array( 'error' => $response->get_error_message() );
        }

        if ( ! empty( $response['body'] ) && $body = json_decode( $response['body'] ) ) {

            if ( isset( $body->status )  && 'error' === $body->status ) {
                return array( 'error' => $body->message );
            }

            $forms = array();

            if ( is_array( $body ) ) {

                foreach ( $body as $key => $form ) {

                    $form_data           = array();
                    $form_data['id']     = $form->portalId;
                    $form_data['guid']   = $form->guid;
                    $form_data['name']   = $form->name;
                    $form_data['fields'] = array();

                    if ( isset( $form->formFieldGroups ) ) {
                        foreach ( $form->formFieldGroups as $key => $formFieldGroups ) {
                            foreach ( $formFieldGroups->fields as $k => $field ) {

                                $form_data['fields'][] = array(
                                    'id'       =>  $field->name,
                                    'name'     =>  $field->label,
                                    'required' =>  $field->required ? true : false,
                                );
                            }
                        }
                    }

                    $forms[$form->guid] = $form_data;
                }
            }

            return array( 'forms' => $forms );
        }

    }

    /**
     * Submit hubspot form
     *
     * @param int $portalId
     * @param string $formGuid
     * @param array $data
     *
     * @return void
     */
    function submit_form( $portalId, $formGuid, $data ) {

        $hubspotutk      = @$_COOKIE['hubspotutk'];
        $ip_addr         = @$_SERVER['REMOTE_ADDR'];

        $hs_context      = array(
            'hutk'      => $hubspotutk,
            'ipAddress' => $ip_addr,
            'pageUrl'   => get_home_url(),
            'pageName'  => get_bloginfo( 'name' )
        );

        $data['hs_context'] = json_encode($hs_context);
        $str_post           = http_build_query( $data );

        $endpoint = "https://forms.hubspot.com/uploads/form/v2/{$portalId}/{$formGuid}";

        $ch = @curl_init();
        @curl_setopt($ch, CURLOPT_POST, true);
        @curl_setopt($ch, CURLOPT_POSTFIELDS, $str_post);
        @curl_setopt($ch, CURLOPT_URL, $endpoint);
        @curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/x-www-form-urlencoded'
        ));
        @curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response    = @curl_exec($ch);
        $status_code = @curl_getinfo($ch, CURLINFO_HTTP_CODE);
        @curl_close($ch);
    }

}
