'use strict';

;(function ($) {

    Vue.component('wpuf-integration-hubspot', {
        template: '#tmpl-wpuf-integration-hubspot',
        mixins: [wpuf_mixins.integration_mixin],

        data: function data() {
            return {
                lists: [],
                fields: [],
                has_fields: false
            };
        },

        created: function created() {
            this.fetchLists();
        },
        methods: {

            updateFieldsMap: function updateFieldsMap() {

                var vm = this;

                if (!vm.settings.guid) {
                    vm.settings.guid = '';
                }

                // computed property doen't seem to be work, when we have no default value
                // as we have to support for old forms, so doing it manually

                if (vm.get_hubspot_fields()) {

                    var fields = {};

                    vm.get_hubspot_fields().forEach(function (field) {
                        fields[field.id] = vm.settings.fields[field.id] || '';
                    });

                    vm.settings.fields = fields;
                    vm.has_fields = true;
                } else {
                    vm.has_fields = false;
                }

                // making sure to have v-model on dynamic things
                vm.$store.commit('updateIntegration', {
                    index: vm.id,
                    value: vm.settings
                });
            },

            get_hubspot_fields: function get_hubspot_fields() {
                var vm = this;
                if (vm.settings.guid && vm.lists[vm.settings.guid]) {
                    return vm.lists[vm.settings.guid].fields;
                }
            },

            update_settings: function update_settings(e, v) {
                this.settings.fields[v] = e.target.value;
            },

            fetchLists: function fetchLists(target) {
                var self = this;

                wp.ajax.send('wpuf_hubspot_fetch_lists', {
                    data: {
                        _wpnonce: weForms.nonce
                    },

                    success: function success(response) {
                        self.lists = response;
                        self.updateFieldsMap();
                    },

                    error: function error(_error) {
                        alert(_error);
                    }
                });
            },

            updateLists: function updateLists(target) {
                var self = this;

                var link = $(target).closest('a');

                link.addClass('updating');

                wp.ajax.send('wpuf_hubspot_update_lists', {
                    data: {
                        _wpnonce: weForms.nonce
                    },

                    success: function success(response) {
                        self.lists = response;
                        self.updateFieldsMap();
                    },

                    error: function error(_error2) {
                        alert(_error2);
                    },

                    complete: function complete() {
                        link.removeClass('updating');
                    }
                });
            },

            insertValue: function insertValue(type, field, property) {
                var value = field !== undefined ? '{' + type + ':' + field + '}' : '{' + type + '}';
                this.settings.fields[property] = value;
            }
        }

    });
})(jQuery);
