<div>
    <div class="wpuf-int-form-row">
        <div class="wpuf-int-field-label">
            <label for="hubspot-list-id"><?php _e( 'Lead flows', 'default' ); ?></label>

            <a href="#" v-on:click.prevent="updateLists($event.target)" class="wpuf-integration-updater" title="<?php esc_attr_e( 'Update the lists', 'default' ); ?>"><span class="dashicons dashicons-update"></span></a>
        </div>
        <div class="wpuf-int-field">
            <select v-model="settings.guid" @change="updateFieldsMap()">
                <option value=""><?php _e( '&mdash; Select List &mdash;', 'default' ); ?></option>
                <option v-for="(list, guid) in lists" :value="guid">{{ list.name }}</option>
            </select>

            <span class="description"><?php _e( 'Select your <a href="https://app.hubspot.com/lead-flows/" target="_blank">HubSpot Lead flow</a> to add contacts', 'default' ); ?></span>
        </div>
    </div>

    <fieldset v-if="has_fields">
        <legend><?php _e( 'Mapping Fields', 'textdomain' ); ?></legend>

        <p class="description" style="padding: 0 0 10px 0;">
            <?php _e( 'Please map the form input fields with HubSpot fields', 'textdomain' ); ?>
        </p>

        <div class="wpuf-int-form-row" v-for="(field,index) in get_hubspot_fields()">
            <div class="wpuf-int-field-label">
                <label>{{ field.name }} <span class="required">{{ field.required ? '*' : '' }}</span></label>
            </div>
            <div class="wpuf-int-field">
                <div class="wpuf-int-field-small">
                    <input type="text" class="regular-text" @input="update_settings($event,field.id)" :value="settings.fields[field.id]">
                    <wpuf-merge-tags v-on:insert="insertValue" :field="field.id"></wpuf-merge-tags>
                </div>
            </div>
        </div>
    </fieldset>
</div>
