'use strict';

;(function ($) {

    Vue.component('wpuf-integration-mailchimp', {
        template: '#tmpl-wpuf-integration-mailchimp',
        mixins: [wpuf_mixins.integration_mixin],

        data: function data() {
            return {
                lists: [],
                categories: []
            };
        },

        created: function created() {
            this.fetchLists();
        },

        computed: {
            hasCategories: function hasCategories() {
                return Object.keys(this.categories).length;
            }
        },

        watch: {
            'settings.list': function settingsList(value) {
                this.categories = [];
            },

            'categories': {
                deep: true,
                handler: function handler(categories) {
                    var self = this;

                    self.settings.interests = [];

                    _.forEach(categories, function (category) {

                        self.settings.interests.push({
                            'id': category.id,
                            'selected': category.selected
                        });
                    });
                }
            }
        },

        methods: {
            fetchLists: function fetchLists(data, callback) {
                var self = this;

                var data = $.extend(false, data, {
                    _wpnonce: weForms.nonce
                });

                wp.ajax.send('weforms_mailchimp_fetch_lists', {
                    data: data,
                    success: function success(response) {
                        if (callback) {
                            callback(response);
                        } else {
                            self.lists = response;
                            self.fetchCategories();
                        }
                    },
                    error: function error(_error) {
                        alert(_error);
                    }
                });
            },

            updateLists: function updateLists(target, data, callback) {
                var self = this;

                var data = $.extend(false, data, {
                    _wpnonce: weForms.nonce
                });

                var link = $(target).closest('a');

                link.addClass('updating');

                wp.ajax.send('weforms_mailchimp_update_lists', {
                    data: data,
                    success: function success(response) {
                        if (callback) {
                            callback(response);
                        } else {
                            self.lists = response;
                        }
                    },
                    error: function error(_error2) {
                        alert(_error2);
                    },

                    complete: function complete() {
                        link.removeClass('updating');
                    }
                });
            },

            fetchCategories: function fetchCategories() {
                var self = this;
                this.fetchLists({
                    'type': 'categories',
                    'list_id': self.settings.list
                }, function (response) {
                    self.setCategoryValue(response);
                });
            },

            setCategoryValue: function setCategoryValue(response) {
                var self = this;

                response = response.map(function (category) {
                    var value = _.findWhere(self.settings.interests, {
                        'id': category.id
                    });

                    if (value == undefined || value.selected == undefined || !value.selected || value.selected == -1) {
                        category.selected = category.type == 'checkboxes' || category.type === 'hidden' ? [] : '';
                    } else {
                        category.selected = value.selected;
                    }

                    return category;
                });

                this.categories = response;
            },

            updateCategories: function updateCategories(target) {
                var self = this;
                this.updateLists(target, {
                    'type': 'categories',
                    'list_id': self.settings.list
                }, function (response) {
                    self.setCategoryValue(response);
                });
            },

            insertValue: function insertValue(type, field, property) {
                var value = field !== undefined ? '{' + type + ':' + field + '}' : '{' + type + '}';

                this.settings.fields[property] = value;
            }
        }
    });
})(jQuery);
