<div>

    <div class="wpuf-int-form-row">
        <div class="wpuf-int-field-label">
            <label><?php _e( 'List', 'default' ); ?><span class="required">*</span></label>
            <a
                href="#"
                v-on:click.prevent="updateLists($event.target)"
                class="wpuf-integration-updater"
                title="<?php esc_attr_e( 'Update the lists', 'default' ); ?>"
            >
                <span class="dashicons dashicons-update"></span>
            </a>
        </div>
        <div class="wpuf-int-field">

            <select v-model="settings.list" @change="fetchCategories();">
                <option value=""><?php _e( '&mdash; Select List &mdash;', 'default' ); ?></option>
                <option v-for="list in lists" :value="list.id">{{ list.name }}</option>
            </select>
        </div>
    </div>

    <div class="wpuf-int-form-row" >
        <div class="wpuf-int-field-label">
            <label><?php _e( 'Groups', 'weforms-pro' ); ?></label>

            <a href="#"
                v-on:click.prevent="updateCategories($event.target)"
                class="wpuf-integration-updater"
                title="<?php esc_attr_e( 'Update Groups', 'weforms-pro' ); ?>"
            >
                <span class="dashicons dashicons-update"></span>
            </a>
        </div>

        <div class="wpuf-int-field">
            <div class="description" style="margin-bottom: 10px;">
                <?php printf(__( 'Select %sgroups%s, you want to assign to the contact.', 'weforms-pro' ), '<a target="blank" href="https://kb.mailchimp.com/lists/groups/getting-started-with-groups">','</a>'); ?>
            </div>
        </div>
    </div>

    <div class="wpuf-int-form-row" v-for="category in categories" v-if="hasCategories" style="margin-bottom: 12px;">
        <div class="wpuf-int-field-label">
            <label>{{ category.name }}</label>
        </div>

        <div class="wpuf-int-field">
            <template v-if="category.type === 'checkboxes' || category.type === 'hidden' || category.type === 'radio'">
                <label
                    v-for="interest in category.interests"
                    :for="'mailchimp_interest_'+category.id+'_'+interest.id"
                >
                    <input
                        v-if="category.type === 'radio'"
                        :id="'mailchimp_interest_'+category.id+'_'+interest.id"
                        type="radio"
                        :value="interest.id"
                        v-model="category.selected"
                    >
                    <input
                        :id="'mailchimp_interest_'+category.id+'_'+interest.id"
                        type="checkbox"
                        :value="interest.id"
                        v-model="category.selected"
                        v-else
                    >
                    {{ interest.name }} &nbsp;
                </label>

            </template>

            <template v-else-if="category.type === 'dropdown'">
                <select style="display: block;" v-model="category.selected">
                    <option value=""><?php _e( '&mdash; Select &mdash;', 'default' ); ?></option>
                    <option v-for="interest in category.interests" :value="interest.id">
                        {{ interest.name }}
                    </option>
                </select>
            </template>
        </div>
    </div>


    <fieldset>
        <legend><?php _e( 'Mapping Fields', 'textdomain' ); ?></legend>

        <p class="description" style="padding: 0 0 10px 0;">
            <?php _e( 'Please map the form input fields with mailchimp required fields', 'textdomain' ); ?>
        </p>

        <div class="wpuf-int-form-row mapping-fields">
            <div class="wpuf-int-field-label">
                <label><?php _e( 'Email Address', 'default' ); ?> <span class="required">*</span></label>
            </div>
            <div class="wpuf-int-field">
                <div class="wpuf-int-field-small">
                    <input type="email" class="regular-text" v-model="settings.fields.email">
                    <wpuf-merge-tags filter="email_address" v-on:insert="insertValue" field="email"></wpuf-merge-tags>
                </div>
            </div>
        </div>

        <div class="wpuf-int-form-row">
            <div class="wpuf-int-field-label">
                <label><?php _e( 'First Name', 'default' ); ?></label>
            </div>
            <div class="wpuf-int-field">
                <div class="wpuf-int-field-small">
                    <input type="text" class="regular-text" v-model="settings.fields.first_name">
                    <wpuf-merge-tags v-on:insert="insertValue" field="first_name"></wpuf-merge-tags>
                </div>
            </div>
        </div>

        <div class="wpuf-int-form-row">
            <div class="wpuf-int-field-label">
                <label><?php _e( 'Last Name', 'default' ); ?></label>
            </div>
            <div class="wpuf-int-field">
                <div class="wpuf-int-field-small">
                    <input type="text" class="regular-text" v-model="settings.fields.last_name">
                    <wpuf-merge-tags v-on:insert="insertValue" field="last_name"></wpuf-merge-tags>
                </div>
            </div>
        </div>
    </fieldset>

    <div class="wpuf-int-form-row">
        <div class="wpuf-int-field">
            <label for="mailchimp-double-optin" class="weforms-switch">
                <input type="checkbox" id="mailchimp-double-optin" v-model="settings.double">
                <span class="switch-slider round"></span>
                <?php _e( 'Use double opt-in', 'default' ); ?>
            </label>
        </div>
    </div>
</div>
