<?php
/**
 * Plugin Name: MailChimp Integration
 * Description: Subscribe a contact to MailChimp when a form is submited
 * Plugin URI: https://wedevs.com/weforms/
 * Thumbnail URL: mailchimp.png
 * Author: weDevs
 * Version: 1.0
 * Author URI: https://wedevs.com
 */
require_once dirname( __FILE__ ) . '/class-integration-mailchimp.php';
/**
 * MailChimp CLass
 */
class WeForms_MailChimp {

    function __construct() {
        add_filter( 'weforms_integrations', array( $this, 'register_integration' ) );
        add_filter( 'weforms_rest_api_class_map', array( $this, 'register_mailchimp_rest_api_integration' ), 10, 1 );
    }

    /**
     * Register default integrations
     *
     * @param  array $integrations
     *
     * @return array
     */
    public function register_integration( $integrations ) {
        $integrations = array_merge( $integrations, array( 'WeForms_Integration_MailChimp' ) );

        return $integrations;
    }

    public function register_mailchimp_rest_api_integration( $class_map ) {
        $class_map[dirname( __FILE__ )  .'/api/class-weforms-mailchimp-controller.php'] = 'WeForms_Mailchimp_Controller';

        return $class_map;
    }
}

new WeForms_MailChimp();
