jQuery(document).ready(function($) {

    var weFormsPayment = {
        init: function(){

            $('body').on('wpuf:postform:success', this.submitPayment);
        },

        data: {},
        previous_message: '',
        stripe_token: '',

        submitPayment: function( e, data ) {
            weFormsPayment.data = data;

            switch( data.payment_method ){

                case 'paypal' :
                    weFormsPayment.submitPaypal(data);

                break;

                case 'stripe' :
                    weFormsPayment.submitStripe(data);
                break;
            }
        },

        submitPaypal: function(data) {


            setTimeout(function(){

                weFormsPayment.previous_message = $('.wpuf-success').text();

                var msg  =  `<div class="weforms-payment-message ">
                    <p class="wefp-message">`+ weFormsPayment.previous_message +`</p>
                    <div><div class="weforms-payment-loading"></div></div>
                    <p class="wefp-redirect-message">`+ weFormsPayment.data.paypal_message +`</p>
                    </div>`;

                $('.wpuf-success').after(msg).text();
                $('.wpuf-success').remove();

            },100);


            var post_data = {
                business: data.business,
                cmd: data.paypal_type,
                upload: 1,
                currency_code: data.currency_code,
                entry_fields: weFormsPayment.data.entry_fields,
                return: data.paypal_return,
                cancel_return: data.cancel_return,
                notify_url: data.notify_url,
            }

            post_data = $.extend(false, post_data, data.products);

            weFormsPayment.postToGateway('https://www.'+data.sandbox+'paypal.com/cgi-bin/webscr', post_data, 'get');
        },

        submitStripe: function(data){
            setTimeout(function(){

                weFormsPayment.previous_message = $('.wpuf-success').text();

                var msg  =  `<div class="weforms-payment-message">
                    <p class="wefp-message">`+ weFormsPayment.previous_message +`</p>
                    <div><div class="weforms-payment-loading"></div></div>
                    <p class="wefp-redirect-message">`+ weFormsPayment.data.stripe_message +`</p>
                    </div>`;

                $('.wpuf-success').after(msg).text();
                $('.wpuf-success').remove();

            },100);

             var stripe = Stripe(data.config.key);

             var post = {
                action: 'weforms-stripe-payment',
                name: data.config.name,
                amount: data.config.amount,
                currency: data.config.currency,
                form_id: weFormsPayment.data.form_id,
                entry_fields: weFormsPayment.data.entry_fields,
                page_id: data.data.page_id,
                success_message: data.stripe_success_message
            };
            if(data.stripe_return) post.stripe_url = data.stripe_return;

            $.post(wpuf_frontend.ajaxurl, post, function(session){

                if (session.success == '1') {
                    stripe.redirectToCheckout({
                        sessionId: session.data.id
                    }).then(function (result) {
                        if (result.error) {
                            alert(result.error.message);
                        }
                    });
                }else{
                   weFormsPayment.payment_error();
                }

            });
        },


        postToGateway: function(path, params, method) {
            method = method || "post";

            var form = document.createElement("form");
            form.setAttribute("method", method);
            form.setAttribute("action", path);

            for(var key in params) {
                if(params.hasOwnProperty(key)) {
                    var hiddenField = document.createElement("input");
                    hiddenField.setAttribute("type", "hidden");
                    hiddenField.setAttribute("name", key);
                    hiddenField.setAttribute("value", params[key]);

                    form.appendChild(hiddenField);
                 }
            }

            document.body.appendChild(form);

            form.submit();
        },

        payment_error: function(){
            $('.weforms-payment-message')
                .after('<div class="wpuf-error">' + weFormsPaymentText.error + '</div>');
            $('.weforms-payment-message').remove();
        },

        payment_success: function( data ){
            $('.weforms-payment-message')
                .after('<div class="wpuf-success">' + data + '</div>');
            $('.weforms-payment-message').remove();
        },
    }


    weFormsPayment.init();
});
