<?php

/**
 * Multiple Product Field Class
 */
class WeForms_Form_Field_Multiple_Product extends WeForms_Field_Contract {

    function __construct() {
        $this->name       = __( 'Multiple Product', 'weforms-pro' );
        $this->input_type = 'multiple_product';
        $this->icon       = 'cubes';
    }

    /**
     * Render the text field
     *
     * @param  array  $field_settings
     * @param  integer  $form_id
     *
     * @return void
     */
    public function render( $field_settings, $form_id ) {
        $selected = isset( $field_settings['selected'] ) ? $field_settings['selected'] : array();
        ?>
        <li <?php $this->print_list_attributes( $field_settings ); ?>>
            <?php $this->print_label( $field_settings ); ?>

            <div class="wpuf-fields" data-required="<?php echo $field_settings['required'] ?>" data-type="radio">

                <?php
                if ( $field_settings['options'] && count( $field_settings['options'] ) > 0 ) {
                    foreach ($field_settings['options'] as $name => $price) {
                        ?>
                        <label <?php echo $field_settings['inline'] == 'yes' ? 'class="wpuf-checkbox-inline"' : 'class="wpuf-checkbox-block"'; ?>>
                            <input
                                type="<?php echo !empty( $field_settings['select_type'] ) &&  $field_settings['select_type'] == 'checkbox' ? 'checkbox' : 'radio'; ?>"
                                class="multiple-product weforms-multiple-product <?php echo 'wpuf_'.$field_settings['name']. '_'. $form_id; ?>"
                                name="<?php echo $field_settings['name']; ?>[]"
                                data-price="<?php echo esc_attr( $price ); ?>"
                                value="<?php echo esc_attr( $name ).'|1|'.$price; ?>"
                                <?php checked( true, is_array($selected) ? in_array($name, $selected) : $selected == $name ) ?>"
                            />
                            <?php echo $name . ' - '; ?>
                            <span class="price"><?php echo weforms_format_price($price); ?></span>
                        </label>
                        <?php
                    }
                }
                $this->help_text( $field_settings ); ?>
            </div>
        </li>
        <?php
    }

    /**
     * Get field options setting
     *
     * @return array
     */
    public function get_options_settings() {
        $default_options  = $this->get_default_option_settings();
        $dropdown_options = array(
            array(
                'name'          => 'options',
                'title'         => __( 'Products', 'weforms-pro' ),
                'type'          => 'product-data',
                'is_multiple'   => false,
                'section'       => 'basic',
                'priority'      => 12,
                'help_text'     => __( 'Add product details', 'weforms-pro' ),
            ),

            array(
                'name'          => 'inline',
                'title'         => __( 'Show in inline list', 'weforms-pro' ),
                'type'          => 'radio',
                'options'       => array(
                    'yes'   => __( 'Yes', 'weforms-pro' ),
                    'no'    => __( 'No', 'weforms-pro' ),
                ),
                'default'       => 'no',
                'inline'        => true,
                'section'       => 'advanced',
                'priority'      => 23,
                'help_text'     => __( 'Show this product in an inline list', 'weforms-pro' ),
            )
        );

        return array_merge( $default_options, $dropdown_options );
    }


    /**
     * prepare_entry
     *
     * @param $field
     *
     * @return mixed
     */
    public function prepare_entry( $field, $args = [] ) {
        $args = ! empty( $args ) ? $args : $_REQUEST;
        $products = array();

        if ( isset( $args[$field['name']] ) && is_array( $args[$field['name']] ) ) {

            foreach ( $args[$field['name']] as $key => $product ) {

                $val = explode("|", $product);

                $name     = !empty( $val[0] ) ? $val[0]  : '';
                $quantity = !empty( $val[1]  ) ? $val[1]  : 0;
                $price    = !empty( $val[2]  ) ? $val[2]  : 0;

                $products[] = array( 'product' => $name, 'quantity' => $quantity, 'price' => $price );
            }


        }

        return $products;
    }


    /**
     * Get the field props
     *
     * @return array
     */
    public function get_field_props() {
        $defaults = $this->default_attributes();
        $props    = array(
            'selected'    => '',
            'select_type' => 'radio',
            'inline'      => 'no',
            'options'     => array( 'Product' => __( 10, 'weforms-pro' ) ),
        );

        return array_merge( $defaults, $props );
    }
}
