<?php

/**
 * Payment Method Field Class
 */
class WeForms_Form_Field_Payment_Method extends WeForms_Form_Field_Checkbox {

    function __construct() {
        $this->name       = __( 'Payment Method', 'weforms-pro' );
        $this->input_type = 'payment_method';
        $this->icon       = 'credit-card';
    }

    /**
     * Render the text field
     *
     * @param  array  $field_settings
     * @param  integer  $form_id
     *
     * @return void
     */
    public function render( $field_settings, $form_id ) {

        $form     = weforms()->form->get($form_id);
        $settings = $form->get_settings();
        $selected = isset( $field_settings['selected'] ) ? $field_settings['selected'] : '';

        if ( $settings['payment_paypal_deactivate'] && $settings['payment_stripe_deactivate'] ) {
            return;
        }

        $options = array();

        if ( $settings['payment_paypal_deactivate'] != 1 ) {
            $options['paypal'] = array(
                'label'            => !empty( $settings['payment_paypal_label'] ) ? $settings['payment_paypal_label'] : __( 'PayPal', 'wefroms-pro'),
                'img'              => !empty( $settings['payment_paypal_images'] ) ? $settings['payment_paypal_images'] : 'https://www.paypalobjects.com/webstatic/mktg/logo/AM_mc_vs_dc_ae.jpg'
            );
        }

        if ( $settings['payment_stripe_deactivate'] != 1 ) {
            $options['stripe'] = array(
                'label'            => !empty( $settings['payment_stripe_label'] ) ? $settings['payment_stripe_label'] : __( 'Credit Card', 'weforms-pro'),
                'img'              => !empty( $settings['payment_stripe_images'] ) && is_array( $settings['payment_stripe_images'] ) ? $settings['payment_stripe_images'] : array('visa', 'mastercard', 'discover', 'amex' ) );
        }

        ?>
        <li <?php $this->print_list_attributes( $field_settings ); ?>>
            <?php $this->print_label( $field_settings ); ?>
            <div class="wpuf-fields" data-required="<?php echo $field_settings['required'] ?>" data-type="radio">
                <?php
                $payment_method_count =  count( $options );
                if ( $payment_method_count > 1 ) {

                    foreach ( $options as $value => $gateway ) {
                        ?>
                        <label class="wpuf-radio-block">

                            <input
                                name="<?php echo $field_settings['name']; ?>"
                                class="<?php echo 'payment_method_' . $value . ' wpuf_'.$field_settings['name']. '_'. $form_id; ?>"
                                type="radio"
                                value="<?php echo esc_attr( $value ); ?>"
                            />

                            <?php _e( $gateway['label'], 'weforms-pro' ); ?> &nbsp;

                            <?php if ( is_array( $gateway['img'] ) ) :

                                foreach ($gateway['img'] as $key => $img) {
                                    ?>
                                        <img src="<?php echo WEFORMS_PRO_URL . '/modules/payment/assets/images/' . $img . '.svg'; ?>" alt="<?php _e( ucfirst( $img ), 'weforms-pro'); ?>" class="wefp-icon-<?php echo $value; ?>" style="height: 22px">
                                    <?php
                                }

                             else: ?>
                                <img src="<?php echo $gateway['img'] ?>" alt="<?php _e($gateway['label'], 'weforms-pro'); ?>" class="wefp-icon-<?php echo $value; ?>">

                            <?php endif; ?>

                        </label>

                        <?php
                    }
                } else {
                    foreach ( $options as $value => $gateway ) {
                        ?>
                        <label class="wpuf-radio-block">

                            <input
                                name="<?php echo $field_settings['name']; ?>"
                                class="<?php echo 'payment_method_' . $value . ' wpuf_'.$field_settings['name']. '_'. $form_id; ?>"
                                type="radio"
                                value="<?php echo esc_attr( $value ); ?>"
                                checked= "checked"
                                style="display:none"
                            />

                            <?php _e( $gateway['label'], 'weforms-pro' ); ?> &nbsp;

                            <?php if ( is_array( $gateway['img'] ) ) :

                                foreach ($gateway['img'] as $key => $img) {
                                    ?>
                                        <img src="<?php echo WEFORMS_PRO_URL . '/modules/payment/assets/images/' . $img . '.svg'; ?>" alt="<?php _e( ucfirst( $img ), 'weforms-pro'); ?>" class="wefp-icon-<?php echo $value; ?>" style="height: 22px">
                                    <?php
                                }

                             else: ?>
                                <img src="<?php echo $gateway['img'] ?>" alt="<?php _e($gateway['label'], 'weforms-pro'); ?>" class="wefp-icon-<?php echo $value; ?>">

                            <?php endif; ?>

                        </label>

                        <?php
                    }
                }
                ?>

                <?php $this->help_text( $field_settings ); ?>
            </div>
        </li>
        <?php
    }

    /**
     * prepare_entry
     *
     * @param $field
     *
     * @return mixed
     */
    public function prepare_entry( $field, $args = [] ) {
        $args = ! empty( $args ) ? $args : $_POST;

        return isset( $args[$field['name']] ) ? $args[$field['name']] : '';
    }

    /**
     * Get field options setting
     *
     * @return array
     */
    public function get_options_settings() {
        $default_options      = $this->get_default_option_settings( false );

        foreach ( $default_options as $key => &$option ) {
            if ( $option['name'] == 'required' ) {
                $option['default'] = 'yes';
                $option['selected'] = 'yes';
            }
        }

        $product_settings = array(
            array(
                'name'          => 'payment-method',
                'title'         => '',
                'type'          => 'field-payment_method',
                'section'       => 'basic',
                'priority'      => 12,
                'help_text'     => __( '', 'weforms-pro' ),
            ),
        );

        return array_merge( $default_options, $product_settings );
    }

    /**
     * Get the field props
     *
     * @return array
     */
    public function get_field_props() {
        $defaults = $this->default_attributes();

        $props    = array(
            'required'    => 'yes'
        );

        return array_merge( $defaults, $props );
    }
}
