<?php

/**
 * Single Product Field Class
 */
class WeForms_Form_Field_Single_Product extends WeForms_Field_Contract {

    function __construct() {
        $this->name       = __( 'Single Product', 'weforms-pro' );
        $this->input_type = 'single_product';
        $this->icon       = 'cube';
    }

    /**
     * Render the text field
     *
     * @param  array  $field_settings
     * @param  integer  $form_id
     *
     * @return void
     */
    public function render( $field_settings, $form_id ) {

        $name            = $field_settings['name'];
        $price           = isset($field_settings['price']) ? $field_settings['price'] : array();
        $quantity        = isset($field_settings['quantity']) ? $field_settings['quantity'] : array();
        $quantity['min'] = ! empty( $quantity['min'] ) ? $quantity['min'] : 0;
        $price['min']    = ! empty( $price['min'] ) ? $price['min'] : 0;
        $price['price']  = ! empty( $price['price'] ) ? $price['price'] : 0;

        ?>
        <li <?php $this->print_list_attributes( $field_settings ); ?>>
            <?php $this->print_label( $field_settings ); ?>

            <div
                class="wpuf-fields weforms-field-single-product"
                data-required="<?php echo $field_settings['required'] ?>"
                data-quantity="<?php echo isset( $quantity['status'] ) && $quantity['status'] ? 'yes' : 'no' ?>"
            >

                <input type="hidden" name="<?php echo $name ?>[name]" value="<?php echo $field_settings['label'] ?>" class="weforms_single_product <?php echo ' wpuf_'.$field_settings['name'].'_'.$form_id; ?>" />

                <?php if( isset( $price['is_flexible'] ) && $price['is_flexible'] ) :  ?>

                    <div class="weforms-single-product-price-warp">

                        <span><?php echo weforms_get_currency( 'symbol' ); ?></span>

                        <input
                            type="number"
                            step="0.01"
                            class="<?php echo 'wpuf_'.$name. '_'. $form_id; ?> weforms-single-product-price"
                            name="<?php echo $name ?>[price]"
                            <?php

                            printf( ' value="%s" ', !empty( $price['min'] ) ? $price['min'] : 0 );
                            printf( ' min="%s" ', $price['min'] );

                            if ( ! empty($price['max']) ) {
                                printf( ' max="%s" ', $price['max'] );
                            }

                            ?>
                        />
                    </div>

                <?php else: ?>

                    <div>
                        <label>
                            <?php
                            if ( isset( $price['type'] ) && $price['type'] == 'donation' ) {
                                echo __( 'Amount: ', 'weforms-pro' );
                            } else {
                                echo __( 'Price: ', 'weforms-pro' );
                            }
                            ?>
                            <span class="input-price"><?php echo weforms_format_price($price['price']); ?></span>
                        </label>
                    </div>

                    <input type="hidden" name="<?php echo $name ?>[price]" class="weforms-single-product-price" value="<?php echo $price['price']; ?>">

                <?php endif; ?>


                <?php if ( isset( $quantity['status'] ) && $quantity['status'] ) :  ?>
                    <div>
                        <label><?php echo __( 'Quantity: ', 'weforms-pro' ) ?></label>

                        <input
                            style="width:100px;"
                            type="number"
                            class="<?php echo 'wpuf_'.$name. '_'. $form_id; ?> weforms-single-product-quantity"
                            name="<?php echo $name ?>[quantity]"
                            <?php

                            printf( ' value="%s" ', !empty( $quantity['min'] ) ? $quantity['min'] : 0 );
                            printf( ' min="%s" ', $quantity['min'] );

                            if ( ! empty($quantity['max']) ) {
                                printf( ' max="%s" ', $quantity['max'] );
                            }

                            ?>
                        />
                    </div>
                <?php else: ?>

                     <input type="hidden" name="<?php echo $name ?>[quantity]" class="weforms-single-product-quantity-hidden" value="1">

                <?php endif; ?>

                <?php $this->help_text( $field_settings ); ?>

            </div>
        </li>
    <?php }

    /**
     * Get field options setting
     *
     * @return array
     */
    public function get_options_settings() {
        $default_options      = $this->get_default_option_settings(true);

        $product_settings = array(
            array(
                'name'          => 'quantity',
                'title'         => '',
                'type'          => 'field-quantity',
                'section'       => 'basic',
                'priority'      => 12,
                'help_text'     => __( '', 'weforms-pro' ),
            ),
            array(
                'name'          => 'price',
                'title'         => '',
                'type'          => 'field-price',
                'section'       => 'basic',
                'priority'      => 11,
                'help_text'     => __( '', 'weforms-pro' ),
            ),
        );

        return array_merge( $default_options, $product_settings );
    }

    /**
     * prepare_entry
     *
     * @param $field
     *
     * @return mixed
     */
    public function prepare_entry( $field, $args = [] ) {
        $args     = ! empty( $args ) ? $args : $_REQUEST;
        $name     = '';
        $quantity = 0;
        $price    = 0;

        if ( isset( $args[$field['name']] ) && is_array( $args[$field['name']] ) ) {
            $val      = $args[$field['name']];
            $name     = !empty( $val['name'] ) ? $val['name']  : '';
            $quantity = !empty( $val['quantity']  ) ? $val['quantity']  : 0;
            $price    = !empty( $val['price']  ) ? $val['price']  : 0;
        }

        return array( 'product' => $name, 'quantity' => $quantity, 'price' => $price );
    }


    /**
     * Get the field props
     *
     * @return array
     */
    public function get_field_props() {
        $defaults = $this->default_attributes();
        $props    = array(
            'price'    => array(),
            'quantity' => array(),
        );

        return array_merge( $defaults, $props );
    }
}
