<?php

/**
 * Total Field Class
 */
class WeForms_Form_Field_Total extends WeForms_Field_Contract {

    function __construct() {
        $this->name       = __( 'Total Field', 'weforms-pro' );
        $this->input_type = 'total';
        $this->icon       = 'usd';

    }

    /**
     * Render the text field
     *
     * @param  array  $field_settings
     * @param  integer  $form_id
     *
     * @return void
     */
    public function render( $field_settings, $form_id ) {

        ?>
        <li <?php $this->print_list_attributes( $field_settings ); ?>>
            <?php $this->print_label( $field_settings ); ?>
            <div class="wpuf-fields total <?php  echo ' wpuf_'.$field_settings['name'].'_'.$form_id; ?>">

                <?php echo weforms_get_currency( 'symbol' ); ?>

                <span class="wefroms-payment-total <?php echo 'wpuf_'.$field_settings['name']. '_'. $form_id; ?>">0</span>

                <?php $this->help_text( $field_settings ); ?>
            </div>
        </li>
    <?php
        $script = ";(function($) {
                $(window).on('load', function() {
                    var calculate_total_amount = function () {
                        var total     = $('.wefroms-payment-total'),
                            total_val = 0;

                        $('.weforms-field-single-product').each(function(){
                            var price                 = $(this).find('.weforms-single-product-price').val(),
                                quantityHiddenField   = $(this).find('.weforms-single-product-quantity-hidden'),
                                style                 = $(this).parent().css('display'),
                                is_field_hidden       = false;

                            quantityHiddenField.attr('value', 1);

                            if ( style === 'none' ) {
                                is_field_hidden = true;
                            }

                            if ( is_field_hidden === true ) {
                                quantityHiddenField.attr('value', 0);
                                price = 0;
                            }

                            if ( !price ) {
                                return;
                            }

                            if ( $(this).attr('data-quantity') == 'yes') {

                                var quantity  = $(this).find('.weforms-single-product-quantity').val();
                                    quantity  = quantity || 0;

                                total_val += parseFloat(quantity) * parseFloat(price);

                            } else if( $(this).find('.weforms-single-product-quantity')[0] &&
                                $(this).find('.weforms-single-product-quantity')[0].checked ) {
                                 total_val += parseFloat(price);
                            } else if( ! $(this).find('.weforms-single-product-quantity')[0]  ) {
                                total_val += parseFloat(price);
                            }
                        });

                        $('.weforms-multiple-product').each(function(){
                            if (this.checked) {
                                total_val += parseFloat($(this).attr('data-price'));
                            }
                        });

                        if ( total_val ) {
                           total_val = total_val.toFixed(2);
                        }

                        total.text(total_val);

                    };

                    $(document).on('keyup mouseup click check', '.weforms-single-product-price, .weforms-single-product-quantity,  .weforms-multiple-product', calculate_total_amount);
                    $(document).on('change', '.wpuf-form-add', calculate_total_amount);

                    calculate_total_amount();
                });
        })(jQuery);";

        wp_add_inline_script( 'weforms-pro-frontend-scripts', $script );
     }

    /**
     * Get field options setting
     *
     * @return array
     */
    public function get_options_settings() {
        $default_options  = $this->get_default_option_settings( false, array( 'required', 'dynamic' ) );

        return $default_options;
    }


    /**
     * Get the field props
     *
     * @return array
     */
    public function get_field_props() {
        $defaults = $this->default_attributes();
        $props    = array(
            'label'     => __( 'Total', 'weforms-pro' ),
            'price'     => 10,
            'size'      => 40,
        );

        return array_merge( $defaults, $props );
    }
}
