<div>
    <h3 class="hndle"><?php _e( 'Payment', 'weforms-pro' ); ?></h3>

    <div class="inside">
        <table class="form-table">
            <tr>
                <th><?php _e( 'Currency', 'weforms-pro' ); ?></th>
                <td>
                    <select class="regular" v-model="settings.currency">
                        <?php
                        $all_currencies = weforms_get_currencies();

                        $currencies = array();

                        foreach ( $all_currencies as $currency ) {

                            printf(
                                '<option value ="%s">%s</option>',
                                $currency['currency'],
                                __($currency['label'] . ' (' . $currency['symbol'] . ')', 'weforms-pro')
                            );
                        }

                        ?>
                    </select>
                </td>
            </tr>
            <tr>
                <th><?php _e( 'Currency Position', 'weforms-pro' ); ?></th>
                <td>
                    <select class="regular" v-model="settings.currency_position">

                        <?php

                        $default_currency_symbol = weforms_get_currency( 'symbol' );

                        $options = array(
                            'left'        => sprintf( '%1$s (%2$s99.99)', __( 'Left', 'weforms-pro' ), $default_currency_symbol ),
                            'right'       => sprintf( '%1$s (99.99%2$s)', __( 'Right', 'weforms-pro' ), $default_currency_symbol ),
                            'left_space'  => sprintf( '%1$s (%2$s 99.99)', __( 'Left with space', 'weforms-pro' ), $default_currency_symbol ),
                            'right_space' => sprintf( '%1$s (99.99 %2$s)', __( 'Right with space', 'weforms-pro' ), $default_currency_symbol ),
                        );

                        foreach ( $options as $key => $option ) {

                            printf( '<option value ="%s">%s</option>', $key, $option  );
                        }

                        ?>
                    </select>
                </td>
            </tr>
            <tr>
                <th><?php _e( 'Thousand Separator', 'weforms-pro' ); ?></th>
                <td>
                    <input type="text" class="small-text" v-model="settings.price_thousand_sep">
                    <p class="help">This sets the thousand separator of displayed prices.</p>
                </td>
            </tr>

            <tr>
                <th><?php _e( 'Decimal Separator', 'weforms-pro' ); ?></th>
                <td>
                    <input type="text" name="" class="small-text" v-model="settings.price_decimal_sep">
                    <p class="help">This sets the decimal separator of displayed prices.</p>
                </td>
            </tr>

            <tr>
                <th><?php _e( 'Number of Decimals', 'weforms-pro' ); ?></th>
                <td>
                    <input type="number" class="small-text" v-model="settings.price_num_decimals">
                    <p class="help">This sets the number of decimal points shown in displayed prices.</p>
                </td>
            </tr>

            <tr class="wpuf-page-id">
                <th><?php _e( 'Payment Success Page', 'weforms' ); ?></th>
                <td>
                    <?php $dropdown = wp_dropdown_pages( array(
                        'name'             => 'wpuf_settings[stripe_page_id]',
                        'show_option_none' => __( '&mdash; Select a page &mdash;', 'weforms' ),
                        'echo'             => false
                    ) );

                    echo str_replace('<select', '<select v-model="settings.payment_redirect_to"', $dropdown );
                    ?>
                </td>
            </tr>

            <tr class="wpuf-email">
                <th><?php _e( 'Payment Success Message', 'weforms' ); ?></th>
                <td>
                    <input type="text" placeholder="Payment Success Message" v-model="settings.payment_success_message" class="regular-text">
                </td>
            </tr>

            <tr class="wpuf-email">
                <th><?php _e( 'Default fields', 'weforms' ); ?></th>
                <td>

                    <label>
                        <input type="checkbox" v-model="settings.payment_default_fields">
                        <?php _e( 'Automatically show Payment Method and Total field on form if that form contains products', 'weforms' ); ?>
                    </label>
                     <p class="help"></p>
                </td>
            </tr>

            <tr>
                <h3 style=" margin-bottom: 0px; font-size: 1.2em;">PayPal</h3>
            </tr>

            <tr class="wpuf-email">
                <th><?php _e( 'Redirecting Message', 'weforms' ); ?></th>
                <td>
                    <input type="text" placeholder="Redirecting Message" v-model="settings.paypal_message" class="regular-text">
                </td>
            </tr>

            <tr>
                <th><?php _e( 'PayPal Email', 'weforms-pro' ); ?></th>
                <td>
                    <input type="email" class="regular-text" v-model="settings.paypal_email" placeholder="demo@domain.com">
                    <p class="help">Enter your email PayPal email address. You will able to override this email for each form you create.</p>
                </td>
            </tr>

            <tr class="wpuf-email">
                <th><?php _e( 'Logo', 'weforms' ); ?></th>
                <td>
                    <weforms-payment-int-settings-logo settings_name="paypal_logo" :settings="settings"></weforms-payment-int-settings-logo>
                    <p class="description"><small>Recommended size is 150x50 px</small></p>
                </td>
            </tr>
            <tr class="wpuf-email">
                <th><?php _e( 'Shipping Address', 'weforms' ); ?></th>
                <td>
                    <select v-model="settings.paypal_ask_shipping">
                        <option value="1">Do not ask address</option>
                        <option value="0">Ask address, not require one</option>
                        <option value="2">Ask address and require one</option>
                    </select>
                </td>
            </tr>


            <tr>
                <h3 style=" margin-bottom: 0px; font-size: 1.2em;">Stripe</h3>
            </tr>


            <tr class="wpuf-email">
                <th><?php _e( 'Redirecting Message', 'weforms' ); ?></th>
                <td>
                    <input type="text" placeholder="Redirecting Message" v-model="settings.stripe_message" class="regular-text">
                </td>
            </tr>

            <tr>
                <th><?php _e( 'Stripe Email', 'weforms-pro' ); ?></th>
                <td>
                    <input type="text" class="regular-text" v-model="settings.stripe_email" placeholder="Stripe Email">
                </td>
            </tr>

            <tr>
                <th><?php _e( 'Publishable Key', 'weforms-pro' ); ?></th>
                <td>
                    <input type="text" class="regular-text" v-model="settings.stripe_key" placeholder="Stripe Publishable Key">
                    <p class="help">Enter <a href="https://dashboard.stripe.com/account/apikeys" target="_blank">Stripe API</a> keys. </p>
                </td>
            </tr>

            <tr>
                <th><?php _e( 'Secret Key', 'weforms-pro' ); ?></th>
                <td>
                    <input type="text" class="regular-text" v-model="settings.stripe_secret_key" placeholder="Stripe Secret Key">
                    <p class="help"></p>
                </td>
            </tr>

            <tr>
                <th><?php _e( 'Test Publishable Key', 'weforms-pro' ); ?></th>
                <td>
                    <input type="text" class="regular-text" v-model="settings.stripe_key_test" placeholder="Stripe Test Publishable Key">
                    <p class="help">Enter <a href="https://dashboard.stripe.com/account/apikeys" target="_blank">Stripe API</a> test keys. </p>
                </td>
            </tr>

            <tr>
                <th><?php _e( 'Test Secret Key', 'weforms-pro' ); ?></th>
                <td>
                    <input type="text" class="regular-text" v-model="settings.stripe_secret_key_test" placeholder="Stripe Test Secret Key">
                    <p class="help"></p>
                </td>
            </tr>


            <tr class="wpuf-email">
                <th><?php _e( 'Logo', 'weforms' ); ?></th>
                <td>
                    <div>
                        <weforms-payment-int-settings-logo settings_name="stripe_logo" :settings="settings"></weforms-payment-int-settings-logo>
                    </div>
                    <p class="description"><small>Recommended minimum size is 128x128px</small></p>

                </td>
            </tr>

            <tr class="wpuf-email">
                <th><?php _e( 'Company Name', 'weforms' ); ?></th>
                <td>
                    <input type="text" placeholder="The name of your company or website" v-model="settings.stripe_company_name" class="regular-text">
                </td>
            </tr>

            <tr class="wpuf-email">
                <th><?php _e( 'Description', 'weforms' ); ?></th>
                <td>
                    <input type="text" placeholder="The name of your company or website" v-model="settings.stripe_company_desc" class="regular-text">
                </td>
            </tr>

            <tr class="wpuf-email">
                <th><?php _e( 'Billing Address', 'weforms' ); ?></th>
                <td>

                    <label>
                        <input type="checkbox" v-model="settings.stripe_ask_billing">
                        <?php _e( 'Ask Billing Address', 'weforms' ); ?>
                    </label>
                </td>
            </tr>

            <tr class="wpuf-email">
                <th><?php _e( 'Shipping Address', 'weforms' ); ?></th>
                <td>

                    <label>
                        <input type="checkbox" v-model="settings.stripe_ask_shipping">
                        <?php _e( 'Ask Shipping Address', 'weforms' ); ?>
                    </label>
                </td>
            </tr>

        </table>
    </div>

		<div class="submit-wrapper">
		    <button v-on:click.prevent="saveSettings($event.target)" class="button button-primary">
                <?php _e( 'Save Changes', 'weforms-pro' ); ?>
            </button>
		</div>

</div>