<table class="form-table">

    <tr class="wpuf-email">
        <th><?php _e( 'PayPal Status', 'weforms-pro' ); ?></th>
        <td>
            <label for="we_paypal_enable">
                <select v-model="settings.payment_paypal_deactivate">
                    <option value=""><?php _e( 'Enable', 'weforms-pro' ); ?></option>
                    <option value="1"><?php _e( 'Disable', 'weforms-pro' ); ?></option>
                </select>
            </label>
        </td>
    </tr>

    <template v-if="!settings.payment_paypal_deactivate">

        <tr class="wpuf-email">
            <th><?php _e( 'PayPal Mode', 'weforms-pro' ); ?></th>
            <td>
                <label for="we_paypal_sandbox">
                    <select v-model="settings.paypal_mode" id="we_paypal_sandbox">
                        <option value="live"><?php _e( 'Production', 'weforms-pro' ) ?></option>
                        <option value="sandbox"><?php _e( 'Sandbox', 'weforms-pro' ) ?></option>
                    </select>
                </label>
            </td>
        </tr>

        <tr class="wpuf-email">
            <th><?php _e( 'Payment Type', 'weforms-pro' ); ?></th>
            <td>
                <label for="we_paypal_type">
                    <select v-model="settings.paypal_type" id="we_paypal_type">
                        <option value="_cart"><?php _e( 'Cart', 'weforms-pro' ) ?></option>
                        <option value="_donations"><?php _e( 'Donation', 'weforms-pro' ) ?></option>
                    </select>
                </label>
            </td>
        </tr>

        <tr class="wpuf-email">
            <th><?php esc_html_e( 'After Submission', 'weforms' ); ?></th>
            <td>
                <label>
                    <input type="checkbox" v-model="settings.after_submission">
                    <?php esc_html_e( 'Form Submission Only After Payment is Successful', 'weforms' ); ?>
                </label>
            </td>
        </tr>
        
        <tr class="wpuf-email">
            <th><?php _e( 'Pre-fill Email', 'weforms-pro' ); ?></th>
            <td>
                <label for="we_prefill_email" class="weforms-switch">
                    <input id="we_prefill_email" type="checkbox" v-model="settings.paypal_prefill_email">
                    <span class="switch-slider round"></span>
                    <?php _e( 'Pre-fill user email address from the form fields', 'weforms-pro' ); ?>
                </label>
            </td>
        </tr>

        <tr class="wpuf-email" v-if="settings.paypal_prefill_email">
            <th><?php _e( '&mdash; Email Field', 'weforms-pro' ); ?></th>
            <td>
                <select v-model="settings.paypal_user_email_field">
                    <option value="">&mdash; Select a field &mdash;</option>
                    <option v-for="field in $store.state.form_fields" :value="field.name">{{ field.label }}</option>
                </select>
            </td>
        </tr>

        <tr class="wpuf-page-id">
            <th><?php _e( 'Thank You Page', 'weforms-pro' ); ?></th>
            <td>
                <?php $dropdown = wp_dropdown_pages( array(
                    'name'             => 'wpuf_settings[paypal_page_id]',
                    'show_option_none' => __( '&mdash; Select a page &mdash;', 'weforms-pro' ),
                    'echo'             => false
                ) );

                echo str_replace('<select', '<select v-model="settings.paypal_page_id"', $dropdown );
                ?>
                 <p class="description"><small>User will redirect to this page after successful payment. Keeping empty will use global Payment Success Page page defined in <a href="<?php echo admin_url('admin.php?page=weforms#/settings'); ?>">settings</a> page. </small></p>
            </td>
        </tr>

        <tr class="wpuf-email">
            <th><?php _e( 'Different Email', 'weforms-pro' ); ?></th>
            <td>
                <label for="we_paypal_override" class="weforms-switch">
                    <input id="we_paypal_override" type="checkbox" v-model="settings.paypal_override">
                    <span class="switch-slider round"></span>
                    <?php _e( 'Use a different PayPal email for this specific form', 'weforms-pro' ); ?>
                </label>
                <p class="description"><small>By default, we'll use default PayPal email defained at your <a href="<?php echo admin_url('admin.php?page=weforms#/settings'); ?>">weForms Settings</a> page. You can override that.</small></p>
            </td>
        </tr>

        <tr class="wpuf-email" v-if="settings.paypal_override">
            <th><?php _e( '&mdash; PayPal Email', 'weforms-pro' ); ?></th>
            <td>
                <input type="email" placeholder="mail@domain.com" v-model="settings.paypal_email" class="regular-text">
            </td>
        </tr>

    </template>
</table>
