<table class="form-table">

    <tr class="wpuf-email">
        <th><?php _e( 'Stripe Status', 'weforms-pro' ); ?></th>
        <td>
            <label for="we_stripe_enable">
                <select v-model="settings.payment_stripe_deactivate">
                    <option value=""><?php _e( 'Enable', 'weforms-pro' ); ?></option>
                    <option value="1"><?php _e( 'Disable', 'weforms-pro' ); ?></option>
                </select>
            </label>
        </td>
    </tr>

    <template v-if="!settings.payment_stripe_deactivate">

        <tr class="wpuf-email">
            <th><?php _e( 'Stripe Mode', 'weforms-pro' ); ?></th>
            <td>
                <label for="we_stripe_mode">
                    <select v-model="settings.stripe_mode" id="we_stripe_mode">
                        <option value="live"><?php _e( 'Production', 'weforms-pro' ) ?></option>
                        <option value="test"><?php _e( 'Test', 'weforms-pro' ) ?></option>
                    </select>
                </label>
            </td>
        </tr>

        <tr class="wpuf-email">
            <th><?php esc_html_e( 'After Submission', 'weforms' ); ?></th>
            <td>
                <label>
                    <input type="checkbox" v-model="settings.after_submission">
                    <?php esc_html_e( 'Form Submission Only After Payment is Successful', 'weforms' ); ?>
                </label>
            </td>
        </tr>

        <tr class="wpuf-email">
            <th><?php _e( 'Pre-fill Email', 'weforms-pro' ); ?></th>
            <td>
                <label for="we_prefill_email_stripe" class="weforms-switch">
                    <input id="we_prefill_email_stripe" type="checkbox" v-model="settings.stripe_prefill_email">
                    <span class="switch-slider round"></span>
                    <?php _e( 'Pre-fill user email address from the form fields', 'weforms-pro' ); ?>
                </label>
            </td>
        </tr>

        <tr class="wpuf-email" v-if="settings.stripe_prefill_email">
            <th><?php _e( '&mdash; Email Field', 'weforms-pro' ); ?></th>
            <td>
                <select v-model="settings.stripe_user_email_field">
                    <option value="">&mdash; Select a field &mdash;</option>
                    <option v-for="field in $store.state.form_fields" :value="field.name">{{ field.label }}</option>
                </select>
            </td>
        </tr>


        <tr class="wpuf-page-id">
            <th><?php _e( 'Thank You Page', 'weforms-pro' ); ?></th>
            <td>
                <?php $dropdown = wp_dropdown_pages( array(
                    'name'             => 'wpuf_settings[stripe_page_id]',
                    'show_option_none' => __( '&mdash; Select a page &mdash;', 'weforms-pro' ),
                    'echo'             => false
                ) );

                echo str_replace('<select', '<select v-model="settings.stripe_page_id"', $dropdown );
                ?>
                <p class="description"><small>User will redirect to this page after successful payment. Keeping empty will use global Payment Success Page page defined in <a href="<?php echo admin_url('admin.php?page=weforms#/settings'); ?>">settings</a> page. </small></p>
            </td>
        </tr>

        <tr class="wpuf-email">
            <th><?php _e( 'Different Keys', 'weforms-pro' ); ?></th>
            <td>
                <label for="we_stripe_override" class="weforms-switch">
                    <input id="we_stripe_override" type="checkbox" v-model="settings.stripe_override_keys">
                    <span class="switch-slider round"></span>
                    <?php _e( 'Use different Stripe API keys for this specific form', 'weforms-pro' ); ?>
                </label>
                <p class="description"><small>By default, we'll use default Stripe keys defained at your <a href="<?php echo admin_url('admin.php?page=weforms#/settings'); ?>">settings</a> page. You can override that.</small></p>
            </td>
        </tr>

        <template v-if="settings.stripe_override_keys">


            <tr class="wpuf-email">
                <th><?php _e( '&mdash; Stripe Email', 'weforms-pro' ); ?></th>
                <td>
                    <input type="email" placeholder="mail@domain.com" v-model="settings.stripe_email" class="regular-text">
                </td>
            </tr>

            <tr class="wpuf-email">
                <th><?php _e( '&mdash; Publishable Key', 'weforms-pro' ); ?></th>
                <td>
                    <input type="text" placeholder="Publishable Key" v-model="settings.stripe_key" class="regular-text">
                </td>
            </tr>

            <tr class="wpuf-email">
                <th><?php _e( '&mdash; Secret key', 'weforms-pro' ); ?></th>
                <td>
                    <input type="text" placeholder="<?php _e( 'Secret Key', 'weforms-pro' ); ?>" v-model="settings.stripe_secret_key" class="regular-text">
                </td>
            </tr>

            <tr class="wpuf-email">
                <th><?php _e( '&mdash; Publishable Test Key', 'weforms-pro' ); ?></th>
                <td>
                    <input type="text" placeholder="<?php _e( 'Publishable Test Key', 'weforms-pro' ); ?>" v-model="settings.stripe_key_test" class="regular-text">
                </td>
            </tr>

            <tr class="wpuf-email">
                <th><?php _e( '&mdash; Secret Test key', 'weforms-pro' ); ?></th>
                <td>
                    <input type="text" placeholder="<?php _e( 'Secret Test Key', 'weforms-pro' ); ?>" v-model="settings.stripe_secret_key_test" class="regular-text">
                </td>
            </tr>

            <tr>
                <hr style="width: 100%">
            </tr>

        </template>

    </template>
</table>
