<?php

/**
 * PDF API Manager
 *
 * @since 1.4.2
 */
class Weforms_Pdf_Controller extends Weforms_REST_Controller {

    /**
     * Endpoint namespace
     *
     * @var string
     */
    protected $namespace = 'weforms/v1';

    /**
     * Route name
     *
     * @var string
     */
    protected $base = 'pdf';


    /**
     * Register all routes releated with forms
     *
     * @return void
     */
    public function register_routes() {

        register_rest_route( $this->namespace, '/'. $this->base . '/(?P<entry_id>[\d]+)/download_entries/',
            array(
                array(
                    'methods'             => WP_REST_Server::READABLE,
                    'callback'            => array( $this, 'get_items' ),
                    'permission_callback' => array( $this, 'get_items_permissions_check' ),
                    'args'   => array(
                        'entry_id' => array(
                            'required'            => true,
                            'description'         => __( 'Unique identifier for the object.' ),
                            'type'                => 'integer',
                            'validate_callback' => array( $this, 'is_entry_exists' ),
                        ),
                        'context' => $this->get_context_param( [ 'default' => 'view' ] )
                    )
                ),
            )
        );
    }

    /**
     * Download
     *
     * @since 1.4.2
     *
     * @param WP_REST_Request $request
     *
     * @return string
     **/
    public function get_items( $request ) {
        global $wpdb;

        $entry_id      = isset( $request['entry_id'] ) ? absint( $request['entry_id'] ) : 0;
        $query         = 'SELECT form_id FROM ' . $wpdb->weforms_entries . ' WHERE id = %d';
        $form_id       = $wpdb->get_var( $wpdb->prepare( $query, $entry_id ) );
        $form          = weforms()->form->get( $form_id );
        $entry         = $form->entries()->get( $entry_id );
        $fields        = $entry->get_fields();
        $form_settings = $form->get_settings();
        $quizForm      = $form_settings['quiz_form'];
        $download_url  = admin_url( 'admin-post.php?action=weforms_pdf_download&entry_id=' . $entry_id );

        $data = array(
            'url'           => $download_url,
            'form'          => $form,
            'form_entries'  => $entry,
            'form_fields'   => $fields,
            'form_settings' => $form_settings,
            'quizForm'      => $quizForm
        );

        $response = rest_ensure_response( $data );

        return $response;
    }
}
