<h3 class="hndle"><?php _e( 'PDF Form Submission', 'weforms-pro' ); ?></h3>

<div class="inside">

    <p class="help">
        <?php printf( __( 'Configure the basic options of PDF form submission', 'weforms-pro' ) ); ?>
    </p>

    <table class="form-table">
        <tr>
            <th><?php _e( 'Header', 'weforms-pro' ); ?></th>
            <td>
                <select v-model="settings.pdf_header_type">
                    <option value=""><?php _e( 'No header', 'weforms-pro' ); ?></option>
                    <option value="title"><?php _e( 'Site title', 'weforms-pro' ); ?></option>
                    <option value="logo"><?php _e( 'Logo', 'weforms-pro' ); ?></option>
                    <option value="html"><?php _e( 'Custom HTML', 'weforms-pro' ); ?></option>
                </select>
            </td>
        </tr>
        <tr v-show="settings.pdf_header_type == 'logo'">
            <th><?php _e( 'Logo URL', 'weforms-pro' ); ?></th>
            <td>
                <input type="url" v-model="settings.pdf_logo" class="regular-text">
                <p class="help">Logo must be hosted on the server</p>
            </td>
        </tr>
        <tr v-show="settings.pdf_header_type == 'html'">
            <th><?php _e( 'HTMl Header', 'weforms-pro' ); ?></th>
            <td>
                <textarea v-model="settings.pdf_custom_html" rows="6" class="regular-text"></textarea>
            </td>
        </tr>
        <tr>
            <th><?php _e( 'Show empty', 'weforms-pro' ); ?></th>
            <td>
                <label for="weforms_pdf_show_empty">
                    <input type="checkbox" id="weforms_pdf_show_empty" v-model="settings.pdf_show_empty">
                    <?php _e( 'Show empty fields on PDF', 'weforms-pro' ); ?>
                </label>
            </td>
        </tr>
        <tr>
            <th><?php _e( 'Show form name', 'weforms-pro' ); ?></th>
            <td>
                <label for="weforms_pdf_show_form_name">
                    <input type="checkbox" id="weforms_pdf_show_form_name" v-model="settings.pdf_show_form_name">
                    <?php _e( 'Show form name after header', 'weforms-pro' ); ?>
                </label>
            </td>
        </tr>
        <tr>
            <th><?php _e( 'PDF on Browser', 'weforms-pro' ); ?></th>
            <td>
                <label for="weforms_pdf_show">
                    <input type="checkbox" id="weforms_pdf_show" v-model="settings.pdf_show">
                    <?php _e( 'Open PDF directly on the browser', 'weforms-pro' ); ?>
                </label>
            </td>
        </tr>
    </table>

</div>

<div class="submit-wrapper">
    <button v-on:click.prevent="saveSettings($event.target)" class="button button-primary"><?php _e( 'Save Changes', 'weforms-pro' ); ?></button>
</div>
