jQuery(document).ready(function($) {

    var weFormsFrontQuiz = {
        init: function () {
            var form_id = [],
                frontend_quiz = [];
            $(".wpuf-form-add :input[name=form_id]").each(function(){
                form_id.push( $(this).val() );
            });
            $(".wpuf-form-add :input[name=weforms-front-quiz]").each(function(){
                frontend_quiz.push( $(this).val() );
            });

            var idx,
                form_selector = '';

            for ( idx = 0; idx < form_id.length; idx++ ) {
                form_selector = '.weforms-' + form_id[idx];
                if ( frontend_quiz[idx] === 'yes' ) {
                    $(form_selector).off();
                    $(form_selector).on('submit', this.frontQuizFormSubmit);
                }
            }
        },

        frontQuizFormSubmit: function (e) {
            e.preventDefault();

            var form = $(this),
                submitButton = form.find('input[type=submit]'),
                form_data = weFormsFrontQuiz.weFormsValidateForm(form);

            if (form_data) {

                // send the request
                form.find('li.wpuf-submit').append('<span class="wpuf-loading"></span>');
                submitButton.attr('disabled', 'disabled').addClass('button-primary-disabled');

                $.post( weforms_frontend_quiz.ajaxurl, form_data, function ( res ) {
                    e.preventDefault();
                    // var res = $.parseJSON(res);
                    var settings        = res.form_settings,
                        userCanSee      = settings.respondent_can_see,
                        totalPoints     = settings.total_points,
                        score           = totalPoints,
                        releaseGrade    = settings.release_grade,
                        output          = '';

                    if ( releaseGrade == 'after_submission' ) {
                        output += '<ul class="wpuf-form form-label-above">';

                        $.each( res.form_fields, function( key, field ) {
                            var template        = field.template,
                                selectedAnswers = field.selected_answers,
                                userChoice      = ( res.data !== undefined ) ? res.data[field.name] : '' ,
                                fieldPoints     = parseFloat(field.points),
                                isRightAnswer   = weFormsFrontQuiz.isRightAnswer(selectedAnswers, userChoice),
                                getPoints       = weFormsFrontQuiz.getPoints(fieldPoints, isRightAnswer);

                            var divClass = (isRightAnswer) ? 'right-answer' : 'wrong-answer';

                            output += '<li class="wpuf-el '+ divClass +'">';
                                output += '<div class="wpuf-label">';
                                    output += '<label for="' + field.name +'">';
                                    output += field.label;
                                    
                                    if (userCanSee.includes( 'point_values' )) {
                                        output += '<span class="weforms-field-points">'+ getPoints +'/'+ fieldPoints +'</span>';
                                    }

                                    output += '</label>';
                                output += '</div>';
                                output += '<div class="wpuf-fields">';
                                    
                                    switch( template ) {
                                        case 'dropdown_field':
                                        case 'radio_field':
                                            $.each( field.options, function( key, value ) {
                                                output += '<label class="wpuf-radio-block '+ weFormsFrontQuiz.isChecked(key, userChoice) +'">';
                                                    output += '<input name="'+ key +'" type="radio" value="'+ value +'" '+ weFormsFrontQuiz.isChecked(key, userChoice) +' disabled>';
                                                    output += value;
                                                output += '</label>';
                                            });


                                            if (!isRightAnswer) {
                                                score -= fieldPoints;

                                                if (userCanSee.includes( 'correct_answers' )) {
                                                    output += '<div class="right-answer-block">';
                                                        output += '<p>Correct answer</p>';
                                                        output += '<label class="wpuf-radio-block">';
                                                            output += '<input type="radio" checked disabled>';
                                                            output += field.options[selectedAnswers];  
                                                        output += '</label>';
                                                    output += '</div>'; 
                                                }   
                                            };

                                            if (userCanSee.includes( 'question_feedback' )) {
                                                if (weFormsFrontQuiz.hasFieldFeedback(field, isRightAnswer)) {
                                                    output += '<div class="weforms-answer-feedback">';
                                                        output += '<p>Feedback</p>';
                                                        output += '<p class="feedback">'+ weFormsFrontQuiz.getFieldFeedback(field, isRightAnswer) +'</p>';
                                                    output += '</div>'; 
                                                }
                                            };
                                            break;
                                        
                                        case 'multiple_select':
                                        case 'checkbox_field':
                                            $.each( field.options, function( key, value ) {
                                                var checked = '';

                                                if (userChoice && userChoice.includes(key) ) {
                                                    checked = 'checked';
                                                }

                                                output += '<label class="wpuf-checkbox-block '+ checked +'">';
                                                    output += '<input name="'+ key +'" type="checkbox" value="'+ value +'" '+ checked +' disabled>';
                                                    output += value;
                                                output += '</label>';
                                            });

                                            if (!isRightAnswer) {
                                                score -= fieldPoints;

                                                if (userCanSee.includes( 'correct_answers' )) {
                                                    output += '<div class="right-answer-block">';
                                                        output += '<p>Correct answer</p>';

                                                        $.each( selectedAnswers, function( key, value ) {
                                                            output += '<label class="wpuf-checkbox-block">';
                                                            output += '<input type="checkbox" checked disabled>';
                                                            output += field.options[value]; 
                                                            output += '</label>';
                                                        });

                                                    output += '</div>'; 
                                                }   
                                            };

                                            if (userCanSee.includes( 'question_feedback' )) {
                                                if (weFormsFrontQuiz.hasFieldFeedback(field, isRightAnswer)) {
                                                    output += '<div class="weforms-answer-feedback">';
                                                        output += '<p>Feedback</p>';
                                                        output += '<p class="feedback">'+ weFormsFrontQuiz.getFieldFeedback(field, isRightAnswer) +'</p>';
                                                    output += '</div>';   
                                                }  
                                            };                                  
                                            break;                                                                              
                                    }

                                output += '</div>';                            
                                output += '';
                            output += '</li>';
                        });

                        output += '</ul>';

                        if (userCanSee.includes( 'point_values' )) {
                            output += '<div class="weforms-quiz-points">';
                                output += 'Total Points ';
                                output += '<span class="score">'+ score +'/'+ totalPoints +'</span>';
                            output += '</div>';
                        }
                        
                    }

                    form.before( '<div class="wpuf-success">' + res.message + '</div><div class="weforms-quiz-feedback">' + output + '</div>');
                    form.slideUp( 'fast', function() {
                        form.remove();
                    });

                    submitButton.removeClass('button-primary-disabled');
                    form.find('span.wpuf-loading').remove();
                });
            }
        },

        weFormsValidateForm: function (self) {

            var temp,
                temp_val = '',
                error = false,
                error_items = [];
            error_type = '';

            // ===== Validate: Text and Textarea ========
            var required = self.find('[data-required="yes"]:visible');

            required.each(function (i, item) {
                // temp_val = $.trim($(item).val());

                // console.log( $(item).data('type') );
                var data_type = $(item).data('type');
                val = '';

                switch (data_type) {
                    case 'rich':
                        var name = $(item).data('id');
                        val = $.trim(tinyMCE.get(name).getContent());

                        if (val === '') {
                            error = true;

                            // make it warn collor
                            weFormsFrontQuiz.weFormsFrontMarkError(item);
                        }
                        break;

                    case 'textarea':
                    case 'text':

                        val = $.trim($(item).val());

                        if (val === '') {
                            error = true;
                            error_type = 'required';

                            // make it warn collor
                            weFormsFrontQuiz.weFormsFrontMarkError(item, error_type);
                        }
                        break;

                    case 'password':
                    case 'confirm_password':
                        var hasRepeat = $(item).data('repeat');

                        val = $.trim($(item).val());

                        if (val === '') {
                            error = true;
                            error_type = 'required';

                            // make it warn collor
                            weFormsFrontQuiz.weFormsFrontMarkError(item, error_type);
                        }

                        if (hasRepeat) {
                            var repeatItem = $('[data-type="confirm_password"]').eq(0);

                            if (repeatItem.val() !== val) {
                                error = true;
                                error_type = 'mismatch';

                                weFormsFrontQuiz.weFormsFrontMarkError(repeatItem, error_type);
                            }
                        }

                        break;

                    case 'select':
                        val = $(item).val();

                        // console.log(val);
                        if (!val || val === '-1') {
                            error = true;
                            error_type = 'required';

                            // make it warn collor
                            weFormsFrontQuiz.weFormsFrontMarkError(item, error_type);
                        }
                        break;

                    case 'multiselect':
                        val = $(item).val();

                        if (val === null || val.length === 0) {
                            error = true;
                            error_type = 'required';

                            // make it warn collor
                            weFormsFrontQuiz.weFormsFrontMarkError(item, error_type);
                        }
                        break;

                    case 'tax-checkbox':
                        var length = $(item).children().find('input:checked').length;

                        if (!length) {
                            error = true;
                            error_type = 'required';

                            // make it warn collor
                            weFormsFrontQuiz.weFormsFrontMarkError(item, error_type);
                        }
                        break;

                    case 'radio':
                        var length = $(item).find('input:checked').length;

                        if (!length) {
                            error = true;
                            error_type = 'required';

                            // make it warn collor
                            weFormsFrontQuiz.weFormsFrontMarkError(item, error_type);
                        }
                        break;

                    case 'file':
                        var length = $(item).find('ul').children().length;

                        if (!length) {
                            error = true;
                            error_type = 'required';

                            // make it warn collor
                            weFormsFrontQuiz.weFormsFrontMarkError(item, error_type);
                        }
                        break;

                    case 'email':
                        var val = $(item).val();

                        if (val !== '') {
                            //run the validation
                            if (!weFormsFrontQuiz.isValidEmail(val)) {
                                error = true;
                                error_type = 'validation';

                                weFormsFrontQuiz.weFormsFrontMarkError(item, error_type);
                            }
                        } else if (val === '') {
                            error = true;
                            error_type = 'required';

                            weFormsFrontQuiz.weFormsFrontMarkError(item, error_type);
                        }
                        break;


                    case 'url':
                        var val = $(item).val();

                        if (val !== '') {
                            //run the validation
                            if (!weFormsFrontQuiz.isValidURL(val)) {
                                error = true;
                                error_type = 'validation';

                                weFormsFrontQuiz.weFormsFrontMarkError(item, error_type);
                            }
                        }
                        break;
                }

            });

            // if already some error found, bail out
            if (error) {
                // add error notice
                weFormsFrontQuiz.addErrorNotice(self, 'end');

                return false;
            }

            var form_data = self.serialize(),
                rich_texts = [];

            // grab rich texts from tinyMCE
            $('.wpuf-rich-validation', self).each(function (index, item) {
                var item = $(item);
                var editor_id = item.data('id');
                var item_name = item.data('name');
                var val = $.trim(tinyMCE.get(editor_id).getContent());

                rich_texts.push(item_name + '=' + encodeURIComponent(val));
            });

            // append them to the form var
            form_data = form_data + '&' + rich_texts.join('&');
            return form_data;
        },

        weFormsFrontMarkError: function(item, error_type) {

            var error_string = '';
            $(item).closest('li').addClass('has-error');

            if ( error_type ) {
                error_string = $(item).closest('li').data('label');
                switch ( error_type ) {
                    case 'required' :
                        error_string = error_string + ' ' + error_str_obj[error_type];
                        break;
                    case 'mismatch' :
                        error_string = error_string + ' ' +error_str_obj[error_type];
                        break;
                    case 'validation' :
                        error_string = error_string + ' ' + error_str_obj[error_type];
                        break;
                }
                $(item).siblings('.wpuf-error-msg').remove();
                $(item).after('<div class="wpuf-error-msg">'+ error_string +'</div>');
            }

            $(item).focus();
        },

        isChecked: function(key, userChoice, attr = 'checked') {
            if (key == userChoice) {
                return attr;
            }
            return '';
        },

        isRightAnswer: function(selectedAnswers, userChoice) {
            if (typeof selectedAnswers === "string" ) {
                if (selectedAnswers == userChoice) {
                    return true;  
                }
                return false
            } else if( typeof selectedAnswers === "object" ) {
                var answers = selectedAnswers.join('|'),
                    choices = userChoice;

                if (choices != null & typeof userChoice == 'object' ) {
                    choices = userChoice.join('|');  
                }

                if (answers == choices) {
                    return true; 
                }
                return false
            }            
        },

        getPoints: function(fieldPoints, isRightAnswer) {
            if (isRightAnswer) {
                return fieldPoints;
            }
            return 0;
        },

        hasFieldFeedback: function(field, isRightAnswer) {
            if (!isRightAnswer && field.incorrect_ans_feeback != "" ) {
                return true;
            } else if ( isRightAnswer && field.correct_ans_feeback != "" ) {
                return true;
            }
            return false;
        },

        getFieldFeedback: function(field, isRightAnswer) {
            if (!isRightAnswer) {
                return field.incorrect_ans_feeback;
            }
            return field.correct_ans_feeback;           
        },

        isValidEmail: function( email ) {
            var pattern = new RegExp(/^((([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+(\.([a-z]|\d|[!#\$%&'\*\+\-\/=\?\^_`{\|}~]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])+)*)|((\x22)((((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(([\x01-\x08\x0b\x0c\x0e-\x1f\x7f]|\x21|[\x23-\x5b]|[\x5d-\x7e]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(\\([\x01-\x09\x0b\x0c\x0d-\x7f]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF]))))*(((\x20|\x09)*(\x0d\x0a))?(\x20|\x09)+)?(\x22)))@((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?$/i);
            return pattern.test(email);
        },

        isValidURL: function(url) {
            var urlregex = new RegExp("^(http:\/\/www.|https:\/\/www.|ftp:\/\/www.|www.|http:\/\/|https:\/\/){1}([0-9A-Za-z]+\.)");
            return urlregex.test(url);
        },

    };

    weFormsFrontQuiz.init();
});
