<?php
/**
 * Plugin Name: Quiz
 * Description: You can create, send, and grade quizzes with weForms
 * Plugin URI: https://wedevs.com/weforms/
 * Thumbnail URL: quiz.png
 * Author: weDevs
 * Version: 1.0
 * Author URI: https://wedevs.com
 *
 */

class WeForms_Quiz extends WeForms_Abstract_Integration {

    /**
     * Init
     */
    function __construct() {

        $this->id                = 'quiz';
        $this->title             = 'Quiz';
        $this->icon              = WEFORMS_PRO_ASSETS . '/images/quiz.png';

        $this->load_settings();

        add_action( 'wpuf_contact_form_settings_tab', array( $this, 'add_settings_tabs' ) );
        add_action( 'wpuf_contact_form_settings_tab_content', array( $this, 'add_settings_tab_contents' ) );
        add_action( 'wpuf_builder_field_options', array( $this, 'add_quiz_section' ) );
        add_filter( 'weforms_frontend_scripts', array( $this, 'frontend_scripts' ), 10, 1 );
        add_action( 'weforms_submit_btn', array( $this, 'load_hidden_fields' ), 10, 2 );
        add_action( 'weforms_checkbox_field_after_label', array( $this, 'display_field_points' ) );
        add_action( 'weforms_radio_field_after_label', array( $this, 'display_field_points' ) );
        add_action( 'weforms_dropdown_field_after_label', array( $this, 'display_field_points' ) );
        add_action( 'weforms_multidropdown_field_after_label', array( $this, 'display_field_points' ) );

        add_filter( 'weforms_checkbox_field_option_settings', array( $this, 'add_field_options' ) );
        add_filter( 'weforms_radio_field_option_settings', array( $this, 'add_field_options' ) );
        add_filter( 'weforms_dropdown_field_option_settings', array( $this, 'add_field_options' ) );
        add_filter( 'weforms_checkbox_field_props', array( $this, 'add_field_props' ) );
        add_filter( 'weforms_radio_field_props', array( $this, 'add_field_props' ) );
        add_filter( 'weforms_dropdown_field_props', array( $this, 'add_field_props' ) );
        add_filter( 'weforms_multidropdown_field_props', array( $this, 'add_field_props' ) );
        add_filter( 'weforms_entry_submission_response', array( $this, 'frontend_submission_response' ) );
        add_filter( 'weforms_render_fields', array( $this, 'shuffle_form_fields' ), 10, 2 );
    }


    /**
     * Add settings tabs
     *
     * @return void
     */
    public function add_settings_tabs() {
        ?>

            <a href="#" :class="['nav-tab', isActiveSettingsTab( 'quizzes' ) ? 'nav-tab-active' : '']" v-on:click.prevent="makeActiveSettingsTab( 'quizzes' )" class="nav-tab"><?php _e( 'Quiz', 'weforms-pro' ); ?></a>

        <?php
    }


    /**
     * Add settings tabs
     *
     * @return void
     */
    public function add_settings_tab_contents() {
        ?>
            <div id="wpuf-metabox-settings-quizzes" class="tab-content" v-show="isActiveSettingsTab('quizzes')">
                <?php include_once dirname( __FILE__ ) . '/views/quizzes-settings.php'; ?>
            </div>

        <?php
    }

    public function add_quiz_section() {
        $builder = $_GET['page'];

        if ( $builder != 'weforms' ) {
            return;
        }

        ob_start();
        ?>
        <div v-if="form_settings.quiz_form === 'yes'" class="option-fields-section">
            <div v-if="quiz_settings.length">
                <h3 class="section-title" @click="show_quiz_settings = !show_quiz_settings">
                    {{ i18n.quiz_options }}  <i :class="[show_quiz_settings ? 'fa fa-angle-down' : 'fa fa-angle-right']"></i>
                </h3>

                <transition name="slide-fade">
                    <div v-show="show_quiz_settings" class="option-field-section-fields">
                        <component
                            v-for="option_field in quiz_settings"
                            :key="option_field.name"
                            :is="'field-' + option_field.type"
                            :option_field="option_field"
                            :editing_form_field="editing_form_field"
                        ></component>
                    </div>
                </transition>
            </div>
        </div>
        <?php
        echo ob_get_clean();
    }


    /**
     *
     * Add Field Options
     *
     * @return array
     */
    public function add_field_options( $dropdown_options ) {
        $dropdown_options[] =  array(
            'name'          => 'correct_answers',
            'title'         => __( 'Correct Answers', 'weforms-pro' ),
            'type'          => 'selected_answers',
            'section'       => 'quiz',
            'priority'      => 24,
            'help_text'     => __( 'Select correct answers', 'weforms-pro' ),
        );

        $dropdown_options[] =  array(
            'name'          => 'correct_ans_feeback',
            'title'         => __( 'Feedback ( Correct Answer )', 'weforms-pro' ),
            'type'          => 'text',
            'section'       => 'quiz',
            'priority'      => 25,
            'help_text'     => __( 'Correct answer feeback to show with the field after submission', 'weforms-pro' ),
        );

        $dropdown_options[] =  array(
            'name'          => 'incorrect_ans_feeback',
            'title'         => __( 'Feedback ( Incorrect Answer )', 'weforms-pro' ),
            'type'          => 'text',
            'section'       => 'quiz',
            'priority'      => 26,
            'help_text'     => __( 'Incorrect answer feeback to show with the field after submission', 'weforms-pro' ),
        );

        $dropdown_options[] =  array(
            'name'          => 'points',
            'title'         => __( 'Points (numeric value)', 'weforms-pro' ),
            'type'          => 'text',
            'variation'     => 'number',
            'section'       => 'quiz',
            'priority'      => 27,
            'help_text'     => __( 'Points for the right answer', 'weforms-pro' ),
            'class'         => 'weforms-quiz-field-point'
        );

        $dropdown_options[] =  array(
            'name'          => 'show_points',
            'title'         => '',
            'type'          => 'checkbox',
            'is_single_opt' => true,
            'options'       => array(
                'yes'   => __( 'Show Points with field?', 'weforms-pro' )
            ),
            'default'       => 'no',
            'inline'        => true,
            'section'       => 'quiz',
            'priority'      => 28,
            'help_text'     => __( 'Select "Yes" if you want to display above points with this field on the frontend', 'weforms-pro' ),
        );

        return $dropdown_options;
    }


    /**
     *
     * Add Field Props
     *
     * @return array
     */
    public function add_field_props( $props ) {
        $props['selected_answers'] = array();
        $props['points'] = 0;

        return $props;
    }


    /**
     *
     * Enqueue frontend quiz script
     *
     */
    public function frontend_scripts( $scripts ) {
        $weforms_version = get_option( 'weforms_version' );

        if ( version_compare( $weforms_version, '1.2.8', '>=' ) ) {
            $scripts['weforms-front-quiz'] =  array(
                'src'       => WEFORMS_PRO_URL . '/modules/quiz/assets/frontend-quiz.js',
                'deps'      => array( 'jquery', 'wpuf-form' ),
                'in_footer' => false
            );

            wp_localize_script( 'weforms-front-quiz', 'weforms_frontend_quiz', array(
                'ajaxurl'       => admin_url( 'admin-ajax.php' )
            ) );
        }

        return $scripts;
    }


    /**
     *
     * Load hidden fields in frontend form
     *
     */
    public function load_hidden_fields( $form_id, $form_settings ) {
        ob_start();
        ?>
            <input type="hidden" name="weforms-front-quiz" value="<?php echo $form_settings['quiz_form']; ?>">
        <?php
        echo ob_get_clean();

    }


    public function frontend_submission_response( $response ) {
        $form_id       = isset( $_POST['form_id'] ) ? intval( $_POST['form_id'] ) : 0;
        $form          = weforms()->form->get( $form_id );
        $form_settings = $form->get_settings();
        $form_fields   = $form->get_fields();

        $response['form_settings'] = $form_settings;
        $response['form_fields'] = $form_fields;

        return $response;
    }


    public function shuffle_form_fields( $fields, $form_id ) {
        $form          = weforms()->form->get( $form_id );
        $form_settings = $form->get_settings();

        if ( $form_settings['shuffle_question_order'] != 'yes' ) {
            return $fields;
        }

        shuffle($fields);

        return $fields;
    }


    public function display_field_points( $field_settings ) {
        $showPoints = isset( $field_settings['show_points'] ) ? $field_settings['show_points'] : 'no';
        $points     = isset( $field_settings['points'] ) ? $field_settings['points'] : '';

        if ( $showPoints == 'yes' && !empty( $points ) ) {
            ob_start();
            ?>
                <div class="weforms-frontend-field-points"><?php echo $points . ' ' . __( 'Points', 'weforms-pro' ); ?></div>
            <?php
            echo ob_get_clean();
        }
    }

}

new WeForms_Quiz();
