'use strict';

Vue.component('wpuf-integration-salesforce', {
    template: '#tmpl-wpuf-integration-salesforce',
    mixins: [wpuf_mixins.integration_mixin],

    data: function data() {
        return {
            lists: [],
            is_authenticated: false
        };
    },
    created: function created() {
        this.fetchLists();
    },
    methods: {

        fetchLists: function fetchLists(target) {
            var self = this;

            wp.ajax.send('weforms_salesforce_fetch_lists', {
                data: {
                    _wpnonce: weForms.nonce,
                    type: self.settings.type
                },

                success: function success(response) {
                    self.lists = response.lists;
                    self.is_authenticated = response.is_authenticated;
                },

                error: function error(_error) {
                    alert(_error);
                }
            });
        },

        updateLists: function updateLists(target) {
            var self = this;

            var link = jQuery(target).closest('a');

            link.addClass('updating');

            wp.ajax.send('weforms_salesforce_update_lists', {
                data: {
                    _wpnonce: weForms.nonce,
                    type: self.settings.type
                },

                success: function success(response) {
                    self.lists = response;
                },

                error: function error(_error2) {
                    alert(_error2);
                },

                complete: function complete() {
                    link.removeClass('updating');
                }
            });
        },

        insertValue: function insertValue(type, field, property) {
            var value = field !== undefined ? '{' + type + ':' + field + '}' : '{' + type + '}';

            this.settings.fields[property] = value;
        }

    }
});

Vue.component('weforms-salesforce-field-mapping', {
    template: '\n    <div class="weforms-field-mapping-custom">\n        <table>\n            <tr>\n                <th>SalesForce Field</th>\n                <th>Form field</th>\n            </tr>\n            <tr v-for="(field,index) in settings.formFields">\n                <td>\n                    <select v-model="field.salesForceField">\n                        <option value="">&mdash; Select Field &mdash;</option>\n                        <option v-for="x in crm_fields" :value="x.id">\n                            {{ x.name }} <template v-if="x.required">(Required)</template>\n                        </option>\n                        <option value="_custom_">Custom</option>\n                    </select>\n\n                    <div v-if="field.salesForceField == \'_custom_\' " class="custom-field-input">\n                        <input\n                            type="text"\n                            placeholder="Enter field name"\n                            v-model="field.salesForceCustom"\n                            >\n                    </div>\n                </td>\n                <td>\n\n                    <select v-model="field.formField">\n                        <option value="">&mdash; Select a field &mdash;</option>\n                        <option v-for="field in $store.state.form_fields" :value="field.name">{{ field.label }}</option>\n                        <option value="_custom_">Custom</option>\n                    </select>\n\n                    <div class="wpuf-int-form-row mapping-fields" v-if="field.formField == \'_custom_\' " style="margin-bottom: 0px; margin-top: 0px; ">\n                        <div class="wpuf-int-field custom-field-input" style="width: 100%">\n                            <input\n                                type="text"\n                                v-model="field.formCustom"\n                                placeholder="Enter custom value or tag"\n                            >\n                            <wpuf-merge-tags v-on:insert="insertValue" :field="index"></wpuf-merge-tags>\n                        </div>\n                    </div>\n                </td>\n                <td>\n                    <a href="#" @click.prevent="remove(index)" class="remove"><i class="fa fa-minus-circle"></i></a>\n                </td>\n            </tr>\n        </table>\n\n        <button class="button button-primary add" @click.prevent="add">Add Field</button>\n    </div>\n\n    ',
    props: ['settings', 'lists'],

    computed: {
        crm_fields: function crm_fields() {
            return this.lists;
        }
    },
    methods: {
        insertValue: function insertValue(type, field, property) {

            var value = field !== undefined ? '{' + type + ':' + field + '}' : '{' + type + '}';

            this.settings.formFields[property].formCustom = value;
        },
        remove: function remove(index) {
            this.settings.formFields.splice(index, 1);
        },
        add: function add() {
            this.settings.formFields.push({ 'salesForceField': '', 'formField': '', 'salesForceCustom': '', 'formCustom': '' });
        }
    }
});
