<div>
    <div v-if="is_authenticated">

        <div class="wpuf-int-form-row">
            <div class="wpuf-int-field-label">
                <label for="hubspot-list-id"><?php _e( 'SObjects Type', 'default' ); ?></label>

                <a href="#" v-on:click.prevent="updateLists($event.target)" class="wpuf-integration-updater" title="<?php esc_attr_e( 'Refresh object fields', 'default' ); ?>"><span class="dashicons dashicons-update"></span></a>
            </div>
            <div class="wpuf-int-field">

                <select v-model="settings.type" id="salesforce-list-id" @change="updateLists">
                    <option value="Contact"><?php _e( 'Contact', 'weforms-pro' ); ?></option>
                    <option value="Lead"><?php _e( 'Lead', 'weforms-pro' ); ?></option>
                </select>
            </div>
        </div>

	    <fieldset>
	        <legend><?php _e( 'Mapping Fields', 'textdomain' ); ?></legend>

	        <p class="description" style="padding: 0 0 10px 0;">
	            <?php _e( 'Please map the form input fields with SalesForce required fields', 'textdomain' ); ?>
	        </p>

	         <weforms-salesforce-field-mapping :settings="settings" :lists="lists"></weforms-salesforce-field-mapping>
	    </fieldset>


    </div>
    <div v-else>
        <?php
            printf(
                __( 'SalesForce account is not authenticated. Authenticate SalesForce from the %ssettings%s page. You may take a look at the %sdocumentation%s.', 'weforms-pro' ),
                '<a href="' . admin_url( 'admin.php?page=weforms#/settings' ) . '">', '</a>',
                '<a href="https://wedevs.com/docs/weforms/integrations/salesforce/" target="_blank" >', '</a>'
            );
        ?>
    </div>
</div>
