<?php


/**
 * Get the option.
 *
 * @return mixed
 */
function weforms_salesforce_get_option( $option ) {
    $integration = get_option( 'weforms_settings_salesforce-integration', [] );

    if ( isset( $integration[$option] ) ) {
        return $integration[$option];
    }

    return null;
}

/**
 * Update the options.
 *
 * @param  array $options
 *
 * @return boolean
 */
function weforms_salesforce_update_options( $options ) {
    $saved_options = get_option( 'weforms_settings_salesforce-integration', [] );
    $options       = array_merge( $saved_options, $options );

    return update_option( 'weforms_settings_salesforce-integration', $options );
}

/**
 * Get the Instance URL.
 *
 * @return string
 */
function weforms_salesforce_get_instance_url() {
    return weforms_salesforce_get_option( 'instance_url' );
}

/**
 * Get the Access Token.
 *
 * @return string
 */
function weforms_salesforce_get_access_token() {
    return weforms_salesforce_get_option( 'access_token' );
}

/**
 * Get the Refresh Token.
 *
 * @return string
 */
function weforms_salesforce_get_refresh_token() {
    return weforms_salesforce_get_option( 'refresh_token' );
}

/**
 * Get Salesforce lists from options.
 *
 * @return array
 */
function weforms_salesforce_get_contact_lists() {
    return weforms_salesforce_get_option( 'contact_lists' );
}

/**
 * Get Salesforce lists from server.
 *
 * @return array
 */
function weforms_salesforce_refresh_contact_lists() {
    $instance_url  = weforms_salesforce_get_instance_url();
    $access_token  = weforms_salesforce_get_access_token();
    $refresh_token = weforms_salesforce_get_refresh_token();

    $salesforce = new \WeDevs\ERP\Salesforce\Salesforce( $instance_url, $access_token,  $refresh_token );
    $lists_array = $salesforce->get_lists();

    $lists = [];

    if ( is_array( $lists_array ) && isset( $lists_array['listviews'] ) ) {
        foreach ( $lists_array['listviews'] as $list ) {
            $lists[] = [
                'id' => $list['id'],
                'name' => $list['label'],
            ];
        }
    }

    return $lists;
}

/**
 * Create a contact.
 *
 * @param  $data
 *
 * @return int
 */
function weforms_salesforce_create_contact( $data ) {
    $contact_id = erp_insert_people( $data );

    if ( ! is_wp_error( $contact_id ) ) {
	    erp_crm_update_contact_hash( $contact_id, $data['contact_owner'] );
	    erp_crm_update_life_stage( $contact_id, $data['life_stage'] );
    }

    return $contact_id;
}
