<h3 class="hndle"><?php _e( 'Salesforce Contacts Sync', 'weforms-pro' ); ?></h3>

<div class="inside wrap">

	<template v-if="settings.salesforce_status">

		<p><?php _e( 'You are <strong>Connected</strong> with salesforce.', 'weforms-pro' ); ?></p>

		<button
			class="button-secondary"
			@click.prevent="settings.salesforce_status = false; post('weforms_salesforce_disconnect')"
		>
			<?php _e( 'Disconnect', 'weforms_salesforce' ); ?>
		</button>

	</template>
	<template v-else>

		<?php

		$salesforce_connect_url =
			 add_query_arg(
				array(
					'grant_type'    => 'authorization_code',
					'response_type' => 'code',
					'display'       => 'page',
					'prompt'        => 'consent',
					'state'         => urlencode( admin_url( 'admin-post.php?action=wefomrs_sales_force_auth' ) ),
                    // 'client_id'     => '3MVG9d8..z.hDcPJNIBoYehe.JIXQUPzKP.1CYnAIVj7rfzZDHIPVjvfYaL4FXmIA1CaRffo0I2vDioAFOpkL',
					'client_id'     => '3MVG9ZL0ppGP5UrC9yYekmd9g_AtHNaHPniiFz5Gt4J0ya5pVs3Axj3d_NxThajZQR2dIENEaKOyRbhyWmX59',
					'redirect_uri'  => urlencode( 'https://api.wperp.com/oauth/salesforce' ),
					// 'redirect_uri'  => 'https://test.dev/post.php',
				),
				'https://login.salesforce.com/services/oauth2/authorize'
			);
		?>
		    <p><?php _e( 'You\'re not connected with your Salesforce account yet. Click on below button to connect.', 'weforms-pro' ); ?></p>
		    <a href="<?php echo $salesforce_connect_url ?>"><button class="button-secondary"><?php _e( 'Connect Now', 'weforms_salesforce' ); ?></button></a>

	</template>

</div>
