<?php
/**
 * Plugin Name: Salesforce Integration
 * Description: Subscribe a contact to Salesforce when a form is submited
 * Plugin URI: https://wedevs.com/weforms/
 * Thumbnail URL: salesforce.png
 * Author: weDevs
 * Version: 1.0
 * Author URI: https://wedevs.com
 *
 */

// don't call the file directly
if ( !defined( 'ABSPATH' ) ) exit;

require_once __DIR__ . '/class-integration-salesforce.php';

/**
 * WeForms_SalesForce
 */
class WeForms_SalesForce {

	function __construct( ) {
        add_filter( 'weforms_integrations', array( $this, 'register_integration' ) );
        add_filter( 'weforms_rest_api_class_map', array( $this, 'register_salesforce_rest_api_integration' ), 10, 1 );
	}

    /**
     * Register default integrations
     *
     * @param  array $integrations
     *
     * @return array
     */
    public function register_integration( $integrations ) {
        $integrations = array_merge( $integrations, array( 'WeForms_Integration_Salesforce' ) );

        return $integrations;
    }

    public function register_salesforce_rest_api_integration( $class_map ) {
        $class_map[dirname( __FILE__ )  .'/api/class-weforms-salesforce-controller.php'] = 'WeForms_Salesforce_Controller';

        return $class_map;
    }
}

new WeForms_SalesForce();
