<?php
namespace WeDevs\WeForms\SMS;

/**
 * SMS Handler class for Clickatell
 *
 * @since 1.0
 */
class Clickatell implements Gateway_Interface{

    /**
     * Username for Clickatel Account
     *
     * @since 1.0
     */
    private $username;

    /**
     * Password for Clickatel Account
     *
     * @since 1.0
     */
    private $password;

    /**
     * API ID for Clickatel Account
     *
     * @since 1.0
     */
    private $api_id;

    /**
     * URL
     *
     * @since 1.0
     */
    private $url;

    /**
     * SMS Body
     *
     * @since 1.0
     */
    private $sms_body;

    /**
     * Twilio Class constructor
     *
     * @since 1.0
     */
    public function __construct() {
        $this->get_credentials();
        $this->prepare();
    }

    /**
     * Setup Credentials
     *
     * @since 1.0
     */
    public function get_credentials() {
        $this->username = weforms_get_settings( 'sms_clickatell_username' );
        $this->password = weforms_get_settings( 'sms_clickatell_password' );
        $this->api_id   = weforms_get_settings( 'sms_clickatell_api_id' );
    }

    /**
     * Prepare SMS
     *
     * @since 1.0
     */
    public function prepare() {
        $this->url = sprintf(
            'http://api.clickatell.com/http/sendmsg?user=%s&password=%s&api_id=%s',
            $this->username,
            $this->password,
            $this->api_id
        );
    }

    /**
     * Send SMS
     *
     * @since 1.0
     */
    public function send( array $cell_no_all, $message ) {
        foreach ( $cell_no_all as $cell_no_single ) {
            $this->url = sprintf( '%s&to=%s&text=%s', $this->url, $cell_no_single, $message );
            $result    = wp_remote_get( $this->url );
        }
    }
}