<?php
namespace WeDevs\WeForms\SMS;
/**
 * SMS Handler class for Clickatell
 *
 * @since 1.0
 */
class Smsglobal implements Gateway_Interface{

    /**
     * Username for Clickatel Account
     *
     * @since 1.0
     */
    private $username;

    /**
     * Password for Clickatel Account
     *
     * @since 1.0
     */
    private $password;

    /**
     * Sender for Clickatel Account
     *
     * @since 1.0
     */
    private $from;

    /**
     * URL
     *
     * @since 1.0
     */
    private $url;

    /**
     * Twilio Class constructor
     *
     * @since 1.0
     */
    public function __construct() {
        $this->get_credentials();
        $this->prepare();
    }

    /**
     * Setup Credentials
     *
     * @since 1.0
     */
    public function get_credentials() {
        $this->username = weforms_get_settings( 'sms_smsglobal_username' );
        $this->password = weforms_get_settings( 'sms_smsglobal_password' );
        $this->from     = weforms_get_settings( 'sms_smsglobal_from' );
    }

    /**
     * Prepare SMS
     *
     * @since 1.0
     */
    public function prepare() {
        $this->url = sprintf(
            'http://api.smsglobal.com/http-api.php?action=sendsms&user=%s&password=%s&from=%s',
            rawurlencode( $this->username ),
            rawurlencode( $this->password ),
            rawurlencode( $this->from )
        );
    }

    /**
     * Send SMS
     *
     * @since 1.0
     */
    public function send( array $cell_no_all, $message ) {
        foreach ( $cell_no_all as $cell_no_single ) {
            $this->url = sprintf( '%s&to=%s&text=%s', $this->url, $cell_no_single, $message );
            $result    = wp_remote_get( $this->url );
        }
    }
}
