<?php
/**
 * Plugin Name: SMS Notification
 * Description: Send SMS notification on form submission
 * Plugin URI: https://wedevs.com/weforms/
 * Thumbnail URL: sms.png
 * Author: weDevs
 * Version: 1.0
 * Author URI: https://wedevs.com
 *
 */

/**
 * SMS Notification
 */
class WeForms_SMS_Notification extends WeForms_Abstract_Integration {

	public $gateway;

    function __construct() {

		$this->id                = 'sms-notification';
		$this->title             = __( 'SMS Notification', 'weforms-pro' );
        $this->icon            = WEFORMS_PRO_ASSETS . '/images/sms.png';
		$this->settings_template = dirname( __FILE__ ) . '/views/settings.php';

		$this->load_settings( 12 );

		$this->setup_gateway();

        add_filter( 'weforms_get_settings', array( $this, 'set_default_settings' ) );

    }

    /**
     * Initializes the WeForms() class
     *
     * Checks for an existing WeForms() instance
     * and if it doesn't find one, creates it.
     */
    public static function init() {
        static $instance = false;

        if ( ! $instance ) {
            $instance = new WeForms_SMS_Notification();
        }

        return $instance;
    }

    /**
     * Set Default Settings
     *
     * @param array $settings
     *
     * @return array
     */
    function set_default_settings( $settings ) {

    	$default_settings = array();

		foreach ( $this->get_settings() as $key => $singel_settings) {
			if ( isset($singel_settings['id']) ) {

				$default_settings[$singel_settings['id']] = '';
			}
		}

        return array_merge($default_settings, $settings);
    }


    /**
     * get_settings
     *
     * @return
     **/
    function get_settings( ) {
		$options = [
		    'twilio'       => __( 'Twilio', 'weforms-pro' ),
		    'clickatell'   => __( 'Clickatell', 'weforms-pro' ),
		    'smsglobal'    => __( 'SMSGlobal', 'weforms-pro' ),
		    'nexmo'        => __( 'Nexmo', 'weforms-pro' ),
		    'hoiio'        => __( 'Hoiio', 'weforms-pro' ),
		    'intellisms'   => __( 'Intellisms', 'weforms-pro' ),
		    'infobip'      => __( 'Infobip', 'weforms-pro' ),
		];

		$fields = [
		    [
		        'title'   => __( 'Active Gateway', 'weforms-pro' ),
		        'type'    => 'select',
		        'options' => $options,
		        'id'      => 'sms_selected_gateway'
		    ],

		    [
		        'title' => __( 'Clickatell', 'weforms-pro' ),
		        'type' => 'title',
		        'gateway'  => 'clickatell'
		    ],
		    [
		        'title' => __( 'Username', 'weforms-pro' ),
		        'type'  => 'text',
		        'id'    => 'sms_clickatell_username',
		        'gateway'  => 'clickatell'
		    ],
		    [
		        'title' => __( 'Password', 'weforms-pro' ),
		        'type'  => 'text',
		        'id'    => 'sms_clickatell_password',
		        'gateway'  => 'clickatell'
		    ],
		    [
				'title' => __( 'API ID', 'weforms-pro' ),
				'type'  => 'text',
				'id'    => 'sms_clickatell_api_id',
				'gateway'  => 'clickatell'
		    ],


		    [
		        'title' => __( 'Twilio', 'weforms-pro' ),
		        'type' => 'title',
		        'gateway'  => 'twilio'
		    ],
		    [
		        'title' => __( 'Number From', 'weforms-pro' ),
		        'type'  => 'text',
		        'id'    => 'sms_twilio_number_from',
		        'gateway'  => 'twilio'
		    ],
		    [
		        'title' => __( 'Account SID', 'weforms-pro' ),
		        'type'  => 'text',
		        'id'    => 'sms_twilio_account_sid',
		        'gateway'  => 'twilio'
		    ],
		    [
		        'title' => __( 'Auth Token', 'weforms-pro' ),
		        'type'  => 'text',
		        'id'    => 'sms_twilio_auth_token',
		        'gateway'  => 'twilio'
		    ],
		    [
		        'title' => __( 'SMSGlobal', 'weforms-pro' ),
		        'type' => 'title',
		        'gateway'  => 'smsglobal'
		    ],
		    [
		        'title' => __( 'Username', 'weforms-pro' ),
		        'type'  => 'text',
		        'id'    => 'sms_smsglobal_username',
		        'gateway'  => 'smsglobal'
		    ],
		    [
		        'title' => __( 'Password', 'weforms-pro' ),
		        'type'  => 'text',
		        'id'    => 'sms_smsglobal_password',
		        'gateway'  => 'smsglobal'
		    ],
		    [
		        'title' => __( 'From', 'weforms-pro' ),
		        'type'  => 'text',
		        'id'    => 'sms_smsglobal_from',
		        'gateway'  => 'smsglobal'
		    ],
		    [
		        'title' => __( 'Nexmo', 'weforms-pro' ),
		        'type' => 'title',
		        'gateway'  => 'nexmo',
		    ],
		    [
		        'title' => __( 'API Key', 'weforms-pro' ),
		        'type'  => 'text',
		        'id'    => 'sms_nexmo_apikey',
		        'gateway'  => 'nexmo',
		    ],
		    [
		        'title' => __( 'API Secret', 'weforms-pro' ),
		        'type'  => 'text',
		        'id'    => 'sms_nexmo_apisecret',
		        'gateway'  => 'nexmo',
		    ],
		    [
		        'title' => __( 'Sender ID', 'weforms-pro' ),
		        'type'  => 'text',
		        'id'    => 'sms_nexmo_sender_id',
		        'gateway'  => 'nexmo',
		    ],
		    [
		        'title' => __( 'Hoiio', 'weforms-pro' ),
		        'type' => 'title',
		        'gateway'  => 'hoiio',
		    ],
		    [
		        'title' => __( 'App ID', 'weforms-pro' ),
		        'type'  => 'text',
		        'id'    => 'sms_hoiio_app_id',
		        'gateway'  => 'hoiio',
		    ],
		    [
		        'title' => __( 'Access Token', 'weforms-pro' ),
		        'type'  => 'text',
		        'id'    => 'sms_hoiio_access_token',
		        'gateway'  => 'hoiio',
		    ],

		    [
		        'title' => __( 'Intellisms', 'weforms-pro' ),
		        'type' => 'title',
		        'gateway'  => 'intellisms',
		    ],
		    [
		        'title' => __( 'Username', 'weforms-pro' ),
		        'type'  => 'text',
		        'id'    => 'sms_intellisms_username',
		        'gateway'  => 'intellisms',
		    ],
		    [
		        'title' => __( 'Password', 'weforms-pro' ),
		        'type'  => 'text',
		        'id'    => 'sms_intellisms_password',
		        'gateway'  => 'intellisms',
		    ],
		    [
		        'title' => __( 'Sender', 'weforms-pro' ),
		        'type'  => 'text',
		        'id'    => 'sms_intellisms_sender',
		        'gateway'  => 'intellisms',
		    ],

		    [
		        'title' => __( 'Infobip', 'weforms-pro' ),
		        'type' => 'title',
		        'gateway'  => 'infobip',
		    ],
		    [
		        'title' => __( 'Username', 'weforms-pro' ),
		        'type'  => 'text',
		        'id'    => 'sms_infobip_username',
		        'gateway'  => 'infobip',
		    ],
		    [
		        'title' => __( 'Password', 'weforms-pro' ),
		        'type'  => 'text',
		        'id'    => 'sms_infobip_password',
		        'gateway'  => 'infobip',
		    ],
		    [
		        'title' => __( 'Sender', 'weforms-pro' ),
		        'type'  => 'text',
		        'id'    => 'sms_infobip_sender',
		        'gateway'  => 'infobip',
		    ],
		];


		foreach ( $fields as $key => &$field ) {

			if ( isset($field['gateway']) ) {
				$field['v-if'] = " settings.sms_selected_gateway == '" . $field['gateway'] . "' ";
				unset($field['gateway']);
			}
		}


		return $fields;

    }

    /**
     * Constructor for Gateway_Handler class
     *
     * @since 1.0
     */
    public function setup_gateway() {
        $selected_gateway = weforms_get_settings( 'sms_selected_gateway' );

        require_once __DIR__ . '/vendor/autoload.php';

        switch ( $selected_gateway ) {

            case 'clickatell':
                $this->gateway = new \WeDevs\WeForms\SMS\Clickatell();
            break;

            case 'twilio':
                $this->gateway = new \WeDevs\WeForms\SMS\Twilio();
            break;

            case 'smsglobal':
                $this->gateway = new \WeDevs\WeForms\SMS\Smsglobal();
            break;

            case 'nexmo':
                $this->gateway = new \WeDevs\WeForms\SMS\Nexmo();
            break;

            case 'hoiio':
                $this->gateway = new \WeDevs\WeForms\SMS\Hoiio();
            break;

            case 'intellisms':
                $this->gateway = new \WeDevs\WeForms\SMS\Intellisms();
            break;

            case 'infobip':
                $this->gateway = new \WeDevs\WeForms\SMS\Infobip();
            break;

            default:
            break;
        }
    }

    /**
     * Ready to send SMS
     *
     * @since 1.0
     */
    public function send_sms( $cell_no_all, $message ) {

       try {
       	 	$this->gateway->send( $cell_no_all, $message );
       	} catch ( Exception $e ){
            weforms()->log( 'error', 'Failed to send SMS: ' .  $e->getMessage() );
       	}
    }
}


/**
 * Initialize the plugin
 *
 * @return \WeForms_SMS_Notification
 */
function weforms_sms() {
    return WeForms_SMS_Notification::init();
}

// kick-off
weforms_sms();
