'use strict';

Vue.component('wpuf-integration-trello', {
    template: '#tmpl-wpuf-integration-trello',
    mixins: [wpuf_mixins.integration_mixin],

    data: function data() {
        return {
            lists: [],
            boards: [],
            members: []
        };
    },

    created: function created() {
        this.fetchBoards();
    },

    methods: {
        fetchBoards: function fetchBoards(target) {
            var self = this;

            wp.ajax.send('weforms_trello_fetch_boards', {
                data: {
                    _wpnonce: weForms.nonce
                },

                success: function success(response) {
                    self.boards = response;

                    self.fetchLists();
                    self.fetchMembers();
                },

                error: function error(_error) {
                    alert(_error);
                }
            });
        },
        updateBoards: function updateBoards(target) {
            var self = this;

            var link = jQuery(target).closest('a');

            link.addClass('updating');

            wp.ajax.send('weforms_trello_update_boards', {
                data: {
                    _wpnonce: weForms.nonce
                },

                success: function success(response) {
                    self.boards = response;
                },

                error: function error(_error2) {
                    alert(_error2);
                },

                complete: function complete() {
                    link.removeClass('updating');
                }
            });
        },
        fetchLists: function fetchLists(target) {
            var self = this;

            wp.ajax.send('weforms_trello_fetch_lists', {
                data: {
                    _wpnonce: weForms.nonce,
                    board: self.settings.board
                },

                success: function success(response) {
                    self.lists = response;
                },

                error: function error(_error3) {
                    alert(_error3);
                }
            });
        },
        updateLists: function updateLists(target) {
            var self = this;

            var link = jQuery(target).closest('a');

            link.addClass('updating');

            wp.ajax.send('weforms_trello_update_lists', {
                data: {
                    _wpnonce: weForms.nonce,
                    board: self.settings.board
                },

                success: function success(response) {
                    self.lists = response;
                },

                error: function error(_error4) {
                    alert(_error4);
                },

                complete: function complete() {
                    link.removeClass('updating');
                }
            });
        },
        fetchMembers: function fetchMembers(target) {
            var self = this;

            wp.ajax.send('weforms_trello_fetch_members', {
                data: {
                    _wpnonce: weForms.nonce,
                    board: self.settings.board
                },

                success: function success(response) {
                    self.members = response;
                },

                error: function error(_error5) {
                    alert(_error5);
                }
            });
        },
        updateMembers: function updateMembers(target) {
            var self = this;

            var link = jQuery(target).closest('a');

            link.addClass('updating');

            wp.ajax.send('weforms_trello_update_members', {
                data: {
                    _wpnonce: weForms.nonce,
                    board: self.settings.board
                },

                success: function success(response) {
                    self.members = response;
                },

                error: function error(_error6) {
                    alert(_error6);
                },

                complete: function complete() {
                    link.removeClass('updating');
                }
            });
        },
        insertValue: function insertValue(type, field, property) {
            var value = field !== undefined ? ' {' + type + ':' + field + '}' : ' {' + type + '}';

            this.settings.fields[property] += value;
        }
    }
});

Vue.component('weforms-trello-settings', {
    template: '\n        <div>\n            <button @click="auth()" class="button button-primary">{{ settings.trello_token ? \'Remove Authorization\' : \'Authorize Trello\' }}</button> \n        </div>\n    ',

    props: ['settings', 'api_key'],

    data: function data() {
        return {
            lists: []
        };
    },

    methods: {
        auth: function auth() {

            // token exists, going to remove
            if (this.settings.trello_token) {

                this.makeEmpty();
                this.saveSettings();

                toastr.info('Authorization Removed');
            } else {

                // auth
                this.authorize();
            }
        },
        loadScript: function loadScript(url, callback) {

            jQuery.ajax({
                url: url,
                dataType: 'script',
                success: callback,
                async: true
            });
        },
        authorize: function authorize() {

            var self = this;

            toastr.options.timeOut = 600;
            toastr.info('Authorizing..');

            // load trello script if not defined
            if (typeof Trello == 'undefined') {

                self.loadScript('https://trello.com/1/client.js?key=' + self.api_key, function () {

                    // script loaded, now open popup
                    self.popup();
                });
            } else {

                self.popup();
            }
        },
        popup: function popup() {

            var self = this;

            if (Trello !== undefined) {

                Trello.authorize({

                    'expiration': 'never',
                    'interactive': true,
                    'name': 'weForms',
                    'persist': false,
                    'scope': {
                        'read': 'allowRead',
                        'write': 'allowWrite',
                        'account': 'allowAccount'
                    },
                    'type': 'popup',
                    'error': function error() {

                        self.makeEmpty();
                        self.saveSettings();
                    },

                    'success': function success() {
                        self.makeEmpty();
                        self.settings.trello_token = Trello.token();
                        self.saveSettings();
                    }
                });
            } else {
                toastr.error('Trello is not defined.');
            }
        },
        saveSettings: function saveSettings() {
            var self = this;

            wp.ajax.send('weforms_save_settings', {
                data: {
                    settings: JSON.stringify(self.settings),
                    _wpnonce: weForms.nonce
                },

                success: function success(response) {

                    // verify done
                    if (self.settings.trello_user_id) {

                        toastr.options.timeOut = 1000;
                        toastr.success('Trello Authorized');
                    }

                    // auth done, but need verification
                    else if (self.settings.trello_token) {

                            toastr.info('Verifying..');
                            self.verifyToken();
                        }
                },
                error: function error(_error7) {
                    console.log(_error7);
                }
            });
        },
        makeEmpty: function makeEmpty() {

            var s = this.settings;

            s.trello_token = '';
            s.trello_user_id = '';
            s.trello_username = '';
            s.trello_fullName = '';
            s.trello_gravatarHash = '';
        },
        verifyToken: function verifyToken() {
            var self = this;

            wp.ajax.send('weforms_trello_verify_token', {
                data: {
                    _wpnonce: weForms.nonce
                },

                success: function success(response) {

                    if (response.id != undefined) {

                        self.settings.trello_user_id = response.id;
                        self.settings.trello_username = response.username;
                        self.settings.trello_fullName = response.fullName;
                        self.settings.trello_gravatarHash = response.gravatarHash;

                        self.saveSettings();
                    }
                },

                error: function error(_error8) {
                    console.log(_error8);
                }
            });
        }
    }
});

Vue.component('weforms-trello-member-selector', {
    template: '\n        <div>\n            <label v-for="member in members[settings.board]" :for="\'trello_member\'+member.id" class=""> \n                <input :id="\'trello_member\'+member.id" type="checkbox" :value="member.id" v-model="selected" @click="updateSelected()"> \n                {{ member.name }} <br>\n            </label>\n        </div>\n    ',

    props: ['settings', 'members'],

    data: function data() {
        return {
            selected: []
        };
    },
    created: function created() {
        this.selected = this.settings.member.split(",");
    },

    methods: {
        updateSelected: function updateSelected() {
            this.settings.member = this.selected.join(",");
        }
    }
});
