<div>
    <div class="wpuf-int-form-row">
        <div class="wpuf-int-field-label">
            <label for="trello-list-id"><?php _e( 'Board', 'weforms-pro' ); ?><span class="required">*</span></label>

            <a href="#" v-on:click.prevent="updateBoards($event.target)" class="wpuf-integration-updater" title="<?php esc_attr_e( 'Update the Board', 'weforms-pro' ); ?>"><span class="dashicons dashicons-update"></span></a>
        </div>
        <div class="wpuf-int-field">
            <select v-model="settings.board" id="trello-list-id" @change="updateLists();updateMembers();">
                <option value=""><?php _e( '&mdash; Select List &mdash;', 'weforms-pro' ); ?></option>
                <option v-for="board in boards" :value="board.id">{{ board.name }}</option>
            </select>

            <span class="description"><?php _e( 'Select your trello board for subscription', 'weforms-pro' ); ?></span>
        </div>
    </div>

    <div class="wpuf-int-form-row">
        <div class="wpuf-int-field-label">
            <label for="trello-list-id"><?php _e( 'List', 'weforms-pro' ); ?><span class="required">*</span></label>

            <a href="#" v-on:click.prevent="updateLists($event.target)" class="wpuf-integration-updater" title="<?php esc_attr_e( 'Update the Lists', 'weforms-pro' ); ?>"><span class="dashicons dashicons-update"></span></a>
        </div>
        <div class="wpuf-int-field">
            <select v-model="settings.list" id="trello-list-id">
                <option value=""><?php _e( '&mdash; Select List &mdash;', 'weforms-pro' ); ?></option>
                <option v-for="list in lists[settings.board]" :value="list.id">{{ list.name }}</option>
            </select>

            <span class="description"><?php _e( 'Select your trello list for subscription', 'weforms-pro' ); ?></span>
        </div>
    </div>

    <div class="wpuf-int-form-row">
        <div class="wpuf-int-field-label">
            <label for="trello-list-id"><?php _e( 'Member', 'weforms-pro' ); ?></label>

            <a href="#" v-on:click.prevent="updateMembers($event.target)" class="wpuf-integration-updater" title="<?php esc_attr_e( 'Update the Members', 'weforms-pro' ); ?>"><span class="dashicons dashicons-update"></span></a>
        </div>
        <div class="wpuf-int-field">

            <p class="description"><?php _e( 'Select trello Members to assign the cards', 'weforms-pro' ); ?></p>

            <weforms-trello-member-selector :settings="settings" :members="members">
            </weforms-trello-member-selector>

        </div>
    </div>


    <fieldset>
        <legend><?php _e( 'Mapping Fields', 'weforms-pro' ); ?></legend>

        <p class="description" style="padding: 0 0 10px 0;">
            <?php _e( 'Please map the form input fields with trello required fields', 'weforms-pro' ); ?>
        </p>

        <div class="wpuf-int-form-row mapping-fields">
            <div class="wpuf-int-field-label">
                <label for="trello-list-id"><?php _e( 'Card Name', 'weforms-pro' ); ?><span class="required">*</span></label>
            </div>
            <div class="wpuf-int-field">
                <div class="wpuf-int-field-small">
                    <input type="text" class="regular-text" v-model="settings.fields.title">
                    <wpuf-merge-tags v-on:insert="insertValue" field="title"></wpuf-merge-tags>
                </div>
            </div>
        </div>

        <div class="wpuf-int-form-row">
            <div class="wpuf-int-field-label">
                <label for="trello-list-id"><?php _e( 'Card Description', 'weforms-pro' ); ?></label>
            </div>
            <div class="wpuf-int-field">
                <div class="wpuf-int-field-small">
                    <textarea class="large-text" v-model="settings.fields.description" rows="5"></textarea>
                    <wpuf-merge-tags v-on:insert="insertValue" field="description"></wpuf-merge-tags>
                </div>
            </div>
        </div>

    </fieldset>
</div>
