<?php
/**
 * Plugin Name: Trello Integration
 * Description: Send data to Trello Board upon form submission
 * Plugin URI: https://wedevs.com/weforms/
 * Thumbnail URL: trello.png
 * Author: weDevs
 * Version: 1.0
 * Author URI: https://wedevs.com
 *
 */

require_once dirname( __FILE__ ) . '/class-integration-trello.php';

/**
 * Trello CLass
 */
class WeForms_Trello {

    function __construct() {
        add_filter( 'weforms_integrations', array( $this, 'register_integration' ) );
        add_filter( 'weforms_rest_api_class_map', array( $this, 'register_trello_rest_api_integration' ), 10, 1 );
    }

    /**
     * Register default integrations
     *
     * @param  array $integrations
     *
     * @return array
     */
    public function register_integration( $integrations ) {
        $integrations = array_merge( $integrations, array( 'WeForms_Integration_Trello' ) );

        return $integrations;
    }

    /**
     * undocumented function
     *
     * @return void
     * @author
     **/
    public function register_trello_rest_api_integration( $class_map ) {
        $class_map[dirname( __FILE__ ) . '/api/class-weforms-trello-controller.php'] = 'Weforms_Trello_Controller';

        return $class_map;
    }
}

new WeForms_Trello();
