'use strict';

;(function ($) {

    Vue.component('wpuf-integration-zoho', {
        template: '#tmpl-wpuf-integration-zoho',
        mixins: [wpuf_mixins.integration_mixin],

        data: function data() {
            return {
                has_token: false
            };
        },
        created: function created() {
            this.isActive();
        },
        methods: {

            insertValue: function insertValue(type, field, property) {
                var value = field !== undefined ? '{' + type + ':' + field + '}' : '{' + type + '}';

                this.settings.fields[property] = value;
            },

            isActive: function isActive() {
                var self = this;

                wp.ajax.send('weforms_zoho_check_token', {
                    data: {
                        _wpnonce: weForms.nonce
                    },

                    success: function success(response) {
                        self.has_token = response;
                    }
                });
            }
        }
    });

    Vue.component('weforms-zoho-settings-save', {
        template: '<button @click.prevent="save($event.target)" class="button button-primary"> <slot></slot> </button> ',
        props: ['settings'],
        computed: {},
        created: function created() {},
        methods: {
            save: function save(target) {
                var self = this;

                $(target).addClass('updating-message');

                wp.ajax.send('weforms_update_zoho_login', {
                    data: {
                        _wpnonce: weForms.nonce,
                        zoho_login: self.settings.zoho_login,
                        zoho_password: self.settings.zoho_password
                    },

                    success: function success(response) {
                        self.settings.zoho_token = true;

                        toastr.success(response);
                    },

                    error: function error(_error) {
                        self.settings.zoho_token = false;
                        toastr.error(_error);
                    },

                    complete: function complete() {
                        $(target).removeClass('updating-message');
                    }
                });
            }
        }
    });

    Vue.component('weforms-zoho-field-mapping', {
        props: ['settings'],

        data: function data() {
            return {
                'zoho_fields': ['Email', 'First Name', 'Last Name', 'Phone', 'Mobile', 'Designation', 'Fax', 'Website', 'Lead Source', 'Lead Status', 'Industry', 'No of Employees', 'Annual Revenue', 'Email Opt Out', 'Skype ID', 'Street', 'City', 'State', 'Zip Code', 'Country', 'Description', 'Assistant']
            };
        },

        methods: {
            insertValue: function insertValue(type, field, property) {

                var value = field !== undefined ? '{' + type + ':' + field + '}' : '{' + type + '}';

                this.settings.formFields[property].formCustom = value;
            },
            remove: function remove(index) {
                this.settings.formFields.splice(index, 1);
            },
            add: function add() {
                this.settings.formFields.push({ 'zohoField': '', 'formField': '', 'zohoCustom': '', 'formCustom': '' });
            }
        }
    });
})(jQuery);
