<div>
    <div class="wpuf-int-form-row">
        <div class="wpuf-int-field-label">
            <label><?php _e( 'Add data to', 'weforms-pro' ); ?></label>
        </div>
        <div class="wpuf-int-field">
            <select v-model="settings.type" id="salesforce-list-id">
                <option value="Contacts"><?php _e( 'Contacts', 'weforms-pro' ); ?></option>
                <option value="Leads"><?php _e( 'Leads', 'weforms-pro' ); ?></option>
            </select>
        </div>
    </div>

    <div class="wpuf-int-form-row">
        <div class="wpuf-int-field-label">
            <label><?php _e( 'Update Existing', 'weforms-pro' ); ?></label>
        </div>
        <div class="wpuf-int-field">
            <label class="weforms-switch">
                <input type="checkbox" value="1" v-model="settings.update">
                <span class="switch-slider round"></span>
                <?php _e( 'If a contact/lead already exists for the email, update it', 'weforms-pro' ); ?>
            </label>
        </div>
    </div>

    <p style="margin-bottom: 10px">
        <?php _e( 'Please make sure to use only those fields are available on your Zoho CRM. You can customize your modules <a href="https://crm.zoho.com/crm/ShowSetup.do?tab=custom&subTab=modules&action=moduleList" target="_blank">here</a>.', 'weforms-pro' ); ?>
    </p>


    <fieldset v-if="has_token">
        <legend>
            <?php _e( 'Mapping Fields', 'weforms-pro' ); ?>
        </legend>

        <weforms-zoho-field-mapping :settings="settings" inline-template>
            <div class="weforms-field-mapping-custom">
                <table>
                    <tr>
                        <th>Zoho Field</th>
                        <th>Form field</th>
                    </tr>
                    <tr v-for="(field,index) in settings.formFields">
                        <td>
                            <select v-model="field.zohoField">
                                <option value="">&mdash; Select Field &mdash;</option>
                                <option v-for="x in zoho_fields" :value="x">{{ x }}</option>
                                <option value="_custom_">Custom</option>
                            </select>

                            <div v-if="field.zohoField == '_custom_' " class="custom-field-input">
                                <input
                                    type="text"
                                    placeholder="Enter field name"
                                    v-model="field.zohoCustom"
                                    >
                            </div>
                        </td>
                        <td>

                            <select v-model="field.formField">
                                <option value="">&mdash; Select a field &mdash;</option>
                                <option v-for="field in $store.state.form_fields" :value="field.name">{{ field.label }}</option>
                                <option value="_custom_">Custom</option>
                            </select>

                            <div class="wpuf-int-form-row mapping-fields" v-if="field.formField == '_custom_' " style="margin-bottom: 0px; margin-top: 0px; ">
                                <div class="wpuf-int-field custom-field-input" style="width: 100%">
                                    <input
                                        type="text"
                                        v-model="field.formCustom"
                                        placeholder="Enter custom value or tag"
                                    >
                                    <wpuf-merge-tags v-on:insert="insertValue" :field="index"></wpuf-merge-tags>
                                </div>
                            </div>
                        </td>
                        <td>
                            <a href="#" @click.prevent="remove(index)" class="remove"><i class="fa fa-minus-circle"></i></a>
                        </td>
                    </tr>
                </table>
                <button class="button button-primary add" @click.prevent="add">Add Field</button>
            </div>
        </weforms-zoho-field-mapping>
    </fieldset>
    <div v-else>
        <?php
            printf(
                __( 'Zoho CRM account is not authenticated. Authenticate Zoho CRM from the %ssettings%s page. You may take a look at the %sdocumentation%s.', 'weforms-pro' ),
                '<a href="' . admin_url( 'admin.php?page=weforms#/settings' ) . '">', '</a>',
                '<a href="https://wedevs.com/docs/weforms/integrations/zoho/" target="_blank" >', '</a>'
            );
        ?>
    </div>
</div>
