<?php
/**
 * Plugin Name: Zoho
 * Description: Add your customers to zoho list when they submit a form
 * Plugin URI: https://wedevs.com/weforms/
 * Thumbnail URL: zoho.svg
 * Author: weDevs
 * Version: 1.0
 * Author URI: https://wedevs.com
 */

require_once dirname( __FILE__ ) . '/class-integration-zoho.php';

/**
 * MailChimp CLass
 */
class WeForms_Zoho {

    function __construct() {
        add_filter( 'weforms_integrations', array( $this, 'register_integration' ) );
    }

    /**
     * Register default integrations
     *
     * @param  array $integrations
     *
     * @return array
     */
    public function register_integration( $integrations ) {

        $integrations = array_merge( $integrations, array( 'WeForms_Integration_Zoho' ) );

        return $integrations;
    }
}

new WeForms_Zoho();
