<?php

namespace WPFormsSignatures;

use WPForms_Updater;

/**
 * Signature field.
 *
 * @since 1.0.0
 */
class Plugin {

	/**
	 * Get a single instance of the addon.
	 *
	 * @since 1.8.0
	 *
	 * @return Plugin
	 */
	public static function get_instance() {

		static $instance;

		if ( ! $instance ) {
			$instance = new self();

			$instance->init();
		}

		return $instance;
	}

	/**
	 * Init class.
	 *
	 * @since 1.8.0
	 */
	public function init() {

		( new Fields\Signature() );

		$this->hooks();
	}

	/**
	 * Add hooks.
	 *
	 * @since 1.8.0
	 */
	private function hooks() {

		add_action( 'wpforms_updater', [ $this, 'updater' ] );
	}

	/**
	 * Load the plugin updater.
	 *
	 * @since 1.0.0
	 *
	 * @param string $key WPForms license key.
	 */
	public function updater( $key ) {

		new WPForms_Updater(
			[
				'plugin_name' => 'WPForms Signatures',
				'plugin_slug' => 'wpforms-signatures',
				'plugin_path' => plugin_basename( WPFORMS_SIGNATURES_FILE ),
				'plugin_url'  => trailingslashit( plugin_dir_url( WPFORMS_SIGNATURES_FILE ) ),
				'remote_url'  => WPFORMS_UPDATER_API,
				'version'     => WPFORMS_SIGNATURES_VERSION,
				'key'         => $key,
			]
		);
	}
}
