<?php
/**
 * Plugin Name:       WPForms Signatures
 * Plugin URI:        https://wpforms.com
 * Description:       Signatures with WPForms.
 * Requires at least: 5.5
 * Requires PHP:      7.0
 * Author:            WPForms
 * Author URI:        https://wpforms.com
 * Version:           1.9.0
 * Text Domain:       wpforms-signatures
 * Domain Path:       languages
 *
 * WPForms is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * any later version.
 *
 * WPForms is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with WPForms. If not, see <https://www.gnu.org/licenses/>.
 */

use WPFormsSignatures\Plugin;

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Plugin version.
 *
 * @since 1.0.0
 */
const WPFORMS_SIGNATURES_VERSION = '1.9.0';

/**
 * Plugin file.
 *
 * @since 1.8.0
 */
const WPFORMS_SIGNATURES_FILE = __FILE__;

/**
 * Plugin path.
 *
 * @since 1.8.0
 */
define( 'WPFORMS_SIGNATURES_PATH', plugin_dir_path( WPFORMS_SIGNATURES_FILE ) );

/**
 * Plugin URL.
 *
 * @since 1.8.0
 */
define( 'WPFORMS_SIGNATURES_URL', plugin_dir_url( WPFORMS_SIGNATURES_FILE ) );

/**
 * Check addon requirements.
 *
 * @since 1.0.0
 * @since 1.8.0 Uses requirements feature.
 */
function wpforms_signatures_load() {

	$requirements = [
		'file'    => WPFORMS_SIGNATURES_FILE,
		'wpforms' => '1.8.6',
	];

	if ( ! function_exists( 'wpforms_requirements' ) || ! wpforms_requirements( $requirements ) ) {
		return;
	}

	wpforms_signatures();
}

add_action( 'wpforms_loaded', 'wpforms_signatures_load' );

/**
 * Get the instance of the addon main class.
 *
 * @since 1.8.0
 *
 * @return Plugin
 */
function wpforms_signatures() {

	require_once WPFORMS_SIGNATURES_PATH . 'vendor/autoload.php';

	return Plugin::get_instance();
}
